﻿// 文字コード:UTF-8
/// @file
#pragma once

//------------------------------------------------------------------------------
namespace lib {

/// スコープ生存期間中のみ、変数を一時的に変化させる
template <typename TType>
class ScopedValueChanger
{
public:
    ScopedValueChanger(TType* aVar, const TType& aValue)
    : mVar(aVar)
    , mOriginalValue(*aVar)
    {
        SYS_ASSERT_POINTER(aVar);
        *mVar = aValue;
    }
    ~ScopedValueChanger()
    {
        *mVar = mOriginalValue;
    }
private:
    TType* mVar;
    TType mOriginalValue;
};

} // namespace
// EOF
