﻿// 文字コード:UTF-8
/// @file
#pragma once

namespace lib {

template <typename T>
class Nullable
{
public:
    inline Nullable();
    inline Nullable(const T& aValue);
    void clear();
    void set(const T& aValue);
    bool hasValue() const { return mHasValue; }
    T& value() { SYS_ASSERT(mHasValue); return mValue; }
    const T& value() const { SYS_ASSERT(mHasValue); return mValue; }
    T getValueOrDefault(const T& aDefaultValue = T()) const { return hasValue() ? mValue : aDefaultValue; }

    /// 代入演算
    Nullable& operator=(const T& aValue) { set(aValue); return *this; }
    /// null 代入演算 (nullable = nullptr)
    /// @note あっても良いかもしれないが、必要性が薄いためひとまず使えないようにしておく
#if 0
    Nullable& operator=(::std::nullptr_t) { clear(); return *this; }
#endif
    /// アクセサ
    T*       operator->()       { return &value(); }
    const T* operator->() const { return &value(); }
    T&       operator*()       { return value(); }
    const T& operator*() const { return value(); }
    /// null 判定
    /// @note Nullable<bool> などで nullable と *nullable の違いがわかりにくいといった懸念があるため、ひとまず使えないようにしておく
    ///       あった方が利便性が高いということであれば有効化しても良いかもしれない
#if 0
    operator bool() const { return hasValue(); }
#endif

private:
    bool mHasValue;
    T mValue;
};

//------------------------------------------------------------------------------
template<class T>
Nullable<T>::Nullable()
: mHasValue()
, mValue()
{
}

//------------------------------------------------------------------------------
template<class T>
Nullable<T>::Nullable(const T& aValue)
: mHasValue(true)
, mValue(aValue)
{
}

//------------------------------------------------------------------------------
template<class T>
void Nullable<T>::clear()
{
    mHasValue = false;
    mValue = T();
}

//------------------------------------------------------------------------------
template<class T>
void Nullable<T>::set(const T& aValue)
{
    mHasValue = true;
    mValue = aValue;
}

} // namespace
// EOF
