﻿// 文字コード:UTF-8
/// @file
#pragma once

// 前方宣言を記述するためのマクロ
// 従来のコーディングルールだと記述が長くなるのでマクロを使用する

// 例:
/*
// 従来の書き方
namespace sys {
namespace lyt {
    class Layout;
}}

// マクロを利用した書き方
LIB_FORWARD_DECLARE(sys, lyt, class Layout);
*/


#define LIB_FORWARD_DECLARE_2(ns1, decl) \
    namespace ns1 { \
        decl; \
    }
#define LIB_FORWARD_DECLARE_3(ns1, ns2, decl) \
    namespace ns1 { \
    namespace ns2 { \
        decl; \
    }}
#define LIB_FORWARD_DECLARE_4(ns1, ns2, ns3, decl) \
    namespace ns1 { \
    namespace ns2 { \
    namespace ns3 { \
        decl; \
    }}}
#define LIB_FORWARD_DECLARE_5(ns1, ns2, ns3, ns4, decl) \
    namespace ns1 { \
    namespace ns2 { \
    namespace ns3 { \
    namespace ns4 { \
        decl; \
    }}}}
#define LIB_FORWARD_DECLARE_6(ns1, ns2, ns3, ns4, ns5, decl) \
    namespace ns1 { \
    namespace ns2 { \
    namespace ns3 { \
    namespace ns4 { \
    namespace ns5 { \
        decl; \
    }}}}}
#define LIB_FORWARD_DECLARE_7(ns1, ns2, ns3, ns4, ns5, ns6, decl) \
    namespace ns1 { \
    namespace ns2 { \
    namespace ns3 { \
    namespace ns4 { \
    namespace ns5 { \
    namespace ns6 { \
        decl; \
    }}}}}}
#define LIB_FORWARD_DECLARE_8(ns1, ns2, ns3, ns4, ns5, ns6, ns7, decl) \
    namespace ns1 { \
    namespace ns2 { \
    namespace ns3 { \
    namespace ns4 { \
    namespace ns5 { \
    namespace ns6 { \
    namespace ns7 { \
        decl; \
    }}}}}}}
#define LIB_FORWARD_DECLARE_9(ns1, ns2, ns3, ns4, ns5, ns6, ns7, ns8, decl) \
    namespace ns1 { \
    namespace ns2 { \
    namespace ns3 { \
    namespace ns4 { \
    namespace ns5 { \
    namespace ns6 { \
    namespace ns7 { \
    namespace ns8 { \
        decl; \
    }}}}}}}}
#define LIB_FORWARD_NUM_ARGS(...) LIB_FORWARD_NUM_ARGS1((__VA_ARGS__, 8, 7, 6, 5, 4, 3, 2, 1))
#define LIB_FORWARD_NUM_ARGS1(tuple) LIB_FORWARD_NUM_ARGS2 tuple
#define LIB_FORWARD_NUM_ARGS2(_1, _2, _3, _4, _5, _6, _7, _8, n, ...) n
#define LIB_FORWARD_DECLARE(...) LIB_FORWARD_DECLARE_EXPAND1(LIB_FORWARD_NUM_ARGS(__VA_ARGS__), __VA_ARGS__)
#define LIB_FORWARD_DECLARE_EXPAND1(num, ...) LIB_FORWARD_DECLARE_EXPAND2(num, __VA_ARGS__)
#define LIB_FORWARD_DECLARE_EXPAND2(num, ...) LIB_FORWARD_DECLARE_##num(__VA_ARGS__)

// EOF
