﻿// 文字コード:UTF-8
/// @file
#pragma once

#include <cstdarg>

//------------------------------------------------------------------------------
namespace lib {

/// FixedString用内部関数
class FixedStringImpl
{
public:
    static int Strcmp(const char* aLhs, const char* aRhs);
    static int Strlen(const char* aStr);

    /// aSize(バッファサイズ)を超えたらassertする仕様。
    static void Strncpy(
        char* aDst,
        const char* aSrc,
        int aSize
        );

    /// aDstの末尾にaSrcを連結する。
    /// @details
    /// aDstのバッファサイズを超える場合、可能な限り連結し、末尾に
    /// NUL文字をつける。
    ///
    /// strncat関数に動作は近いが、第3引数のサイズの意味は違うので注意。
    /// (そのために関数名を違うものにしている)
    ///
    /// @param aDst 連結先の文字列。ここに既に入っている文字列の後ろにaSrcがつく
    /// @param aSrc 連結する文字列。
    /// @param aDstBufferWholeSize aDstのバッファ全体のサイズ。
    ///   NUL文字のための領域も含む。
    static void Append(
        char* aDst,
        const char* aSrc,
        int aDstBufferWholeSize
        );

    static void VPrintf(
        char* aBuffer,
        int aLength,
        ::std::va_list aArg,
        const char* aFormat
        );
};

} // namespace
// EOF
