﻿// 文字コード:UTF-8
/// @file
#pragma once

//------------------------------------------------------------------------------
namespace lib {

/// @addtogroup LIB
//@{
/// コンテナ要素をdeleteする関数オブジェクト。
/// @details
/// ポインタを格納するコンテナを破棄する際に、各要素をdeleteするのに使用する。
/// <pre><code> 使用例
/// std::vector<Foo *> v;
/// v.push_back(new Foo());
/// ...
/// for_each(v.begin(), v.end(), DeleteObject());
/// </code></pre>
///
/// 参考：Effective STL 第７項「newしたポインタのコンテナを使うときは、必ず
/// ポインタをdeleteした後にコンテナを破棄しよう」
struct DeleteObject
{
    template <typename Deletee> void operator()(const Deletee* aPtr) const
    {
        delete aPtr;
    }
};
//@}

} // namespace
// EOF
