﻿// 文字コード:UTF-8
/// @file
#pragma once

#include <lib/Type.hpp>
#include <lib/Color4bPod.hpp>

//------------------------------------------------------------------------------
namespace lib {

/// @addtogroup LIB
//@{
/// Color4bPod のクラス版。
class Color4b
    : public Color4bPod
{
public:
    /// @name コンストラクタ
    //@{
    Color4b();                           ///< Zero() で作成。
    Color4b(const Color4bPod& aRGBA);    ///< Color4bPodをコピーして作成。
    Color4b(uint8_t aR, uint8_t aG, uint8_t aB, uint8_t aA); ///< RGBAを指定して作成。
    Color4b(uint32_t aColor);                 ///< 0xRRGGBBAA形式で一度に指定して作成
    //@}
};
//@}

} // namespace
// EOF
