﻿// 文字コード:UTF-8
/// @file
#include <lib/Color4b.hpp>

//------------------------------------------------------------------------------
namespace lib {

//------------------------------------------------------------------------------
Color4b::Color4b()
: Color4bPod(Zero())
{
}

//------------------------------------------------------------------------------
Color4b::Color4b(const Color4bPod& aRGBA)
: Color4bPod(aRGBA)
{
}

//------------------------------------------------------------------------------
Color4b::Color4b(const uint8_t aR, const uint8_t aG, const uint8_t aB, const uint8_t aA)
{
    r = aR;
    g = aG;
    b = aB;
    a = aA;
}

//------------------------------------------------------------------------------
Color4b::Color4b(uint32_t aColor)
{
    r = static_cast<uint8_t>((aColor & 0xff000000) >> 24);
    g = static_cast<uint8_t>((aColor & 0x00ff0000) >> 16);
    b = static_cast<uint8_t>((aColor & 0x0000ff00) >> 8);
    a = static_cast<uint8_t>((aColor & 0x000000ff) >> 0);
}

} // namespace
// EOF
