﻿// 文字コード:UTF-8
/// @file
#pragma once

//------------------------------------------------------------------------------
namespace lib {


/// @addtogroup LIB-Util
//@{
/// @name 配列長
//@{
/// @brief  配列の数を得るマクロ。
/// @details 静的データ等に数を格納するために使用します。
#define LIB_ARRAY_NUM(aArrayVariable) \
    (sizeof(aArrayVariable) / sizeof(aArrayVariable[0]))

/// @brief 配列とその数を連続して初期化するマクロ
/// @details 配列とその数をまとめて格納する際に使用します。
#define LIB_ARRAY_AND_NUM(aArrayVariable) \
    aArrayVariable, LIB_ARRAY_NUM(aArrayVariable)
//@}
//@}

} // namespace
// EOF
