﻿// 文字コード:UTF-8
/// @file
#pragma once

#include "lib/FixedString.hpp"
#include "lib/AutoDeleteArray.hpp"
#include "lib/MutableArray.hpp"

//------------------------------------------------------------------------------
class SplitCommand
{
public:

    enum class CommandKind
    {
        Help,
        Web,
        Offline,
        CallbackUrl,
        CallbackableUrl,
        LeftStickMode,
        UserIndex,
        BackgroundKind,
        BootDisplayKind,
        DisplayUrlKind,
        FooterEnabled,
        PointerEnabled,
        BootAsMediaPlayer,
        JsExtensionEnabled,
        KeyRepeatDelayFrame,
        KeyRepeatPulseFrame,
        UserAgentAdditionalString,
        TouchEnabledOnContents,
        MediaPlayerAutoCloseEnabled,
        WebAudioEnabled,
        PageCacheEnabled,
        FooterFixedKind,
        PageFadeEnabled,
        BootLoadingIconEnabled,
        PageScrollIndicatorEnabled,
        MediaPlayerSpeedControlEnabled,
        TERM,
    };

    SplitCommand(int aArgCount, char** aArgValue);
    ~SplitCommand();

    bool isValid() const { return !mItemArray.isEmpty(); }
    bool requiresHelp() const { return mRequiresHelp; }
    bool hasKey(const char* aKey) const;
    bool hasKey(CommandKind aKind) const;
    int getInt(const char* aKey) const;
    int getInt(CommandKind aKind) const;
    int getIntOrDefaultValue(const char* aKey, int aDefaultValue) const;
    int getIntOrDefaultValue(CommandKind aKind, int aDefaultValue) const;
    const char* getString(const char* aKey) const;
    const char* getString(CommandKind aKind) const;
    const char* getStringOrDefaultValue(const char* aKey, const char* aDefaultValue) const;
    const char* getStringOrDefaultValue(CommandKind aKind, const char* aDefaultValue) const;
    bool getBool(const char* aKey) const;
    bool getBool(CommandKind aKind) const;
    bool getBoolOrDefaultValue(const char* aKey, bool aDefaultValue) const;
    bool getBoolOrDefaultValue(CommandKind aKind, bool aDefaultValue) const;

#if DEBUG_IS_ENABLED
     void reset(int aArgCount, char** aArgValue);
#endif

     static ::lib::ShortString48 ToString(CommandKind akind);
     static const char* ToReadPtr(CommandKind aKind);

private:
    void resetImpl(int aArgCount, char** aArgValue);
    bool needsDisplayHelp(const char* aCurArg);
    bool needsDisplayHelp(const char* aCurArg, const char* aNextArg);

    static const int ItemArrayCapacity = 32;
    static const int ValueMaxLength = 4096;
    typedef ::lib::FixedString<ValueMaxLength> ValueType;

    struct Item
    {
        Item(const ::lib::ShortString48 aKey, const ValueType aValue)
        : mKey(aKey)
        , mValue(aValue)
        {
        }
        ::lib::ShortString48 mKey;
        ValueType mValue;
    };

    int getItemIndex(const char* aKey) const;
    int getItemIndex(CommandKind aKind) const;
    void dump();

    typedef ::lib::AutoDeleteArray<Item, ItemArrayCapacity> ItemArray;
    ItemArray mItemArray;
    bool mRequiresHelp;
};
//------------------------------------------------------------------------------
// EOF
