﻿// 文字コード:UTF-8
/// @file
#include "OfflineCommand.hpp"

#include <nn/web.h>

namespace {

const char* fExitReasonToString(::nn::web::OfflineExitReason aExitReason){
    switch (aExitReason) {
    case ::nn::web::OfflineExitReason_EndButtonPressed:
        return "EndButtonPressed";
    case ::nn::web::OfflineExitReason_BackButtonPressed:
        return "BackButtonPressed";
    case ::nn::web::OfflineExitReason_ExitMessage:
        return "ExitMessage";
    case ::nn::web::OfflineExitReason_CallbackUrlReached:
        return "CallbackUrlReached";
    case ::nn::web::OfflineExitReason_LastWindowDeleted:
        return "LastWindowDeleted";
    case ::nn::web::OfflineExitReason_LocalNetworkDisconnectionDenied:
        return "LocalNetworkDisconnectionDenied";
    case ::nn::web::OfflineExitReason_MediaPlayerClosed:
        return "MediaPlayerClosed";
    case ::nn::web::OfflineExitReason_CausedByWebPage:
        return "CausedByWebPage";
    case ::nn::web::OfflineExitReason_Unexpected:
        return "Unexpected";
    default:
        SYS_ASSERT_NOT_REACHED();
    }
    return nullptr;
}

}

//------------------------------------------------------------------------------
bool OfflineCommand::Command(const InternalArgs& aInternalArgs)
{
    SYS_ASSERT(aInternalArgs.showAppletKind() == InternalArgs::ShowAppletKind::Offline);

    ::lib::ScopedPtr<::nn::web::ShowOfflineHtmlPageArg> arg;
    ::nn::web::OfflineHtmlPageReturnValue rValue;

    arg.reset(new ::nn::web::ShowOfflineHtmlPageArg(aInternalArgs.documentPath().buffer()));
    arg->SetBootAsMediaPlayer(aInternalArgs.isBootAsMediaPlayer());
    arg->SetMediaPlayerAutoCloseEnabled(aInternalArgs.isMediaPlayerAutoCloseEnabled());
    arg->SetWebAudioEnabled(aInternalArgs.isWebAudioEnabled());
    arg->SetPointerEnabled(aInternalArgs.isPointerEnabled());
    arg->SetLeftStickMode(::nn::web::OfflineLeftStickMode(aInternalArgs.leftStickMode()));
    arg->SetFooterEnabled(aInternalArgs.isFooterEnabled());
    arg->SetFooterFixedKind(::nn::web::OfflineFooterFixedKind(aInternalArgs.footerFixedKind()));
    arg->SetBootDisplayKind(::nn::web::OfflineBootDisplayKind(aInternalArgs.bootDisplayKind()));
    arg->SetBackgroundKind(::nn::web::OfflineBackgroundKind(aInternalArgs.backgroundKind()));
    if (aInternalArgs.keyRepeatDelayFrame() > -1 &&
        aInternalArgs.keyRepeatPulseFrame() > -1) {
        arg->SetKeyRepeatFrame(aInternalArgs.keyRepeatDelayFrame(), aInternalArgs.keyRepeatPulseFrame());
    }
    arg->SetJsExtensionEnabled(aInternalArgs.isJsExtensionEnabled());
    arg->SetTouchEnabledOnContents(aInternalArgs.isTouchEnabledOnContents());
    arg->SetPageCacheEnabled(aInternalArgs.isPageCacheEnabled());
    arg->SetPageFadeEnabled(aInternalArgs.isPageFadeEnabled());
    arg->SetBootLoadingIconEnabled(aInternalArgs.isBootLoadingIconEnabled());
    arg->SetPageScrollIndicatorEnabled(aInternalArgs.isPageScrollIndicatorEnabled());
    arg->SetMediaPlayerSpeedControlEnabled(aInternalArgs.isMediaPlayerSpeedControlEnabled());

    auto result = ::nn::web::ShowOfflineHtmlPage(&rValue, *arg);
    if (result.IsFailure()) {
        NN_LOG("OfflineApplet canceld\n");
    }

    NN_LOG("[OutParam] exitReason: %s\n", fExitReasonToString(rValue.GetOfflineExitReason()));
    if (rValue.GetOfflineExitReason() == ::nn::web::OfflineExitReason_CallbackUrlReached) {
        if (rValue.GetLastUrlSize() > 0) {
            NN_LOG("[OutParam] LastUrl: %s\n", rValue.GetLastUrl());
        }
    }

    return result.IsSuccess();
}

//------------------------------------------------------------------------------
// EOF
