﻿/*---------------------------------------------------------------------------*
  Copyright (C)2015 Nintendo Co., Ltd.  All rights reserved.

  These coded instructions, statements, and computer programs contain
  proprietary information of Nintendo of America Inc. and/or Nintendo
  Company Ltd., and are protected by Federal copyright law.  They may
  not be disclosed to third parties or copied or duplicated in any form,
  in whole or in part, without the prior written consent of Nintendo.
 *---------------------------------------------------------------------------*/

#include <nn/os.h>
#include <nn/nn_Abort.h>
#include <nn/nn_SdkLog.h>

extern "C"
{

#include <sys/malloc.h>
#include <sys/systm.h>
#include <sys/kernel.h>
#include <siglo/client.h>

//
// vtab_set() is not in performance critical path, vtab_get() is.
//

void vtab_set(void* addr, uintptr_t value)
{
    client* container = client_find_by_mempool(addr);
    NN_ABORT_UNLESS(container != nullptr);
    container->cl_vtab_entries[((uintptr_t)addr - (uintptr_t)container->cl_mempool) / PAGE_SIZE] = value;
}

uintptr_t vtab_get(void* addr)
{
    client* container = client_find_by_mempool(addr);
    NN_ABORT_UNLESS(container != nullptr);
    return container->cl_vtab_entries[((uintptr_t)addr - (uintptr_t)container->cl_mempool) / PAGE_SIZE];
}
}
