﻿/*---------------------------------------------------------------------------*
  Copyright (C)2015 Nintendo Co., Ltd.  All rights reserved.

  These coded instructions, statements, and computer programs contain
  proprietary information of Nintendo of America Inc. and/or Nintendo
  Company Ltd., and are protected by Federal copyright law.  They may
  not be disclosed to third parties or copied or duplicated in any form,
  in whole or in part, without the prior written consent of Nintendo.
 *---------------------------------------------------------------------------*/

#include <nn/os.h>
#include <nn/nn_Abort.h>
#include <nn/nn_SdkLog.h>

extern "C" {

#include <sys/types.h>
#include <sys/param.h>
#include <sys/kernel.h>
#include <sys/systm.h>

struct {
    const char* name;
    uint32_t value;
} ntunables[] = {
    { "net.fibs",                         2 }, /* # of routing tables */
    { "net.add_addr_allfibs",             1 }, /* add routes to all FIBs for new interfaces */
    { "net.isr.maxthreads",               1 }, /* single netisr thread */
    { "net.isr.bindthreads",              0 }, /* do not bind netisr threads to cpu's */
    { "net.isr.maxqlimit",            10240 }, /* per workstream queue limit */
    { "net.isr.defaultqlimit",          256 }, /* qlimit for igmp, arp, ether and ip6 */
    { "net.inet.ip.mcast.maxgrpsrc",    512 },
    { "net.inet.ip.mcast.maxsocksrc",   128 },
    { "net.inet.ip.mcast.loop",           1 },
    { "net.inet6.ip6.mcast.maxgrpsrc",  512 },
    { "net.inet6.ip6.mcast.maxsocksrc", 128 },
    { "net.inet6.ip6.mcast.loop",         1 },
    { "net.inet6.mld.v1enable",           1 },
    { "net.inet6.mld.use_allow",          1 },
    { "net.link.ifqmaxlen",             256 },
    { "net.inet.ip.mfchashsize",        256 },
    { "net.inet.pim.squelch_wholepkt",    0 },
    { "kern.ipc.maxmbufmem",              0 },  /* max mbuf related memory */
    { "kern.ipc.nmbclusters",          1024 },  /* 2 MB */
    { "kern.ipc.nmbjumbop",             512 },  /* 2 MB */
    { "kern.ipc.nmbjumbo9",               0 },
    { "kern.ipc.nmbjumbo16",              0 },
    { "kern.ipc.maxsockets",           1024 },
    { "kern.ipc.nmbufs",                  0 }, /* # of mbufs */
    { "vm.zone.warnings",                 0 },
};

struct {
    const char* name;
    const char* string;
} strtunables[] = {
    { "net.isr.dispatch", "direct" },
};

void tunable_int_init(void *data)
{
    unsigned int i;
    struct tunable_int *d = (struct tunable_int *)data;
    for (i = 0; i < sizeof(ntunables) / sizeof(ntunables[0]); i++) {
        if (strcmp(d->path, (char*)ntunables[i].name) == 0) {
            *(d->var) = (int)ntunables[i].value;
            return;
        }
    }
    return;
}

void tunable_ulong_init(void * data)
{
    struct tunable_long *d = (struct tunable_long *)data;
    unsigned int i;
    for (i = 0; i < sizeof(ntunables) / sizeof(ntunables[0]); i++) {
        if (strcmp(d->path, (char*)ntunables[i].name) == 0) {
            *(d->var) = (unsigned long)ntunables[i].value;
            return;
        }
    }
    return;
}

int getenv_ulong(const char *name, unsigned long *data)
{
    unsigned int i;
    for (i = 0; i < sizeof(ntunables) / sizeof(ntunables[0]); i++) {
        if (strcmp(ntunables[i].name, (char*)name) == 0) {
            *data = (unsigned long)ntunables[i].value;
            return 1;
        }
    }
    return 0;
}

int getenv_int(const char *name, int *data)
{
    unsigned int i;
    for (i = 0; i < sizeof(ntunables) / sizeof(ntunables[0]); i++) {
        if (strcmp(ntunables[i].name, (char*)name) == 0) {
            *data = (int)ntunables[i].value;
            return 1;
        }
    }
    return 0;
}

int getenv_string(const char *name, char *data, int size)
{
    unsigned int i;
    for (i = 0; i < sizeof(strtunables) / sizeof(strtunables[0]); i++) {
        if (strcmp(name, strtunables[i].name) == 0) {
            strlcpy(data, strtunables[i].string, size);
            return 1;
        }
    }
    return 0;
}

}

