﻿/*
 * System call prototypes.
 */

#ifndef _SYS_SYSPROTO_H_
#define	_SYS_SYSPROTO_H_

#include <sys/socket.h>

struct proc;
struct thread;

struct open_args {
    char *  path;
    int     flags;
    int     mode;
};
struct read_args {
    int     fd;
    void *  buf;
    size_t  nbyte;
};
struct write_args {
    int     fd;
    const   void * buf;
    size_t  nbyte;
};
struct close_args {
    int fd;
};
struct recvmsg_args {
    int     s;
    struct  msghdr * msg;
    int     flags;
};
#ifdef __SigloBSD__
struct recvmmsg_args {
    int     s;
    struct  mmsghdr * msgvec;
    size_t  vlen;
    int     flags;
    struct  timespec * timeout;
};
struct sendmmsg_args {
    int     s;
    struct  mmsghdr * msgvec;
    size_t  vlen;
    int     flags;
};
#endif
struct sendmsg_args {
    int     s;
    struct  msghdr * msg;
    int     flags;
};
struct recvfrom_args {
    int     s;
    caddr_t buf;
    size_t  len;
    int     flags;
    struct sockaddr * from;
    socklen_t * fromlenaddr;
};
struct accept_args {
    int     s;
    struct  sockaddr * name;
    socklen_t * anamelen;
};
struct getpeername_args {
    int     fdes;
    struct  sockaddr * asa;
    socklen_t * alen;
};
struct getsockname_args {
    int     fdes;
    struct  sockaddr * asa;
    socklen_t * alen;
};
struct ioctl_args {
    int     fd;
    u_long  com;
    caddr_t data;
};
struct socket_args {
    int     domain;
    int     type;
    int     protocol;
};
struct connect_args {
    int     s;
    caddr_t name;
    int     namelen;
};
struct bind_args {
    int     s;
    caddr_t name;
    int     namelen;
};
struct setsockopt_args {
    int     s;
    int     level;
    int     name;
    caddr_t val;
    int     valsize;
};
struct listen_args {
    int     s;
    int     backlog;
};
struct getsockopt_args {
    int     s;
    int     level;
    int     name;
    caddr_t val;
    int *   avalsize;
};
struct sendto_args {
    int     s;
    caddr_t buf;
    size_t  len;
    int     flags;
    caddr_t to;
    int     tolen;
};
struct shutdown_args {
    int     s;
    int     how;
};
struct socketpair_args {
    int     domain;
    int     type;
    int     protocol;
    int *   rsv;
};
struct setfib_args {
    int     fibnum;
};
struct select_args {
    int      nd;
    fd_set * in;
    fd_set * ou;
    fd_set * ex;
    const struct timeval * tv;
};
struct poll_args {
    struct pollfd * fds;
    uint   nfds;
    int    timeout;
};
struct sysctl_args {
    int *    name;
    u_int    namelen;
    void *   oldctl;
    size_t * oldlenp;
    void *   newctl;
    size_t   newlen;
};
struct sctp_peeloff_args {
    int      sd;
    uint32_t name;
};
struct sctp_generic_sendmsg_args {
    int       sd;
    caddr_t   msg;
    int       mlen;
    caddr_t   to;
    socklen_t tolen;
    struct sctp_sndrcvinfo * sinfo;
    int       flags;
};
struct sctp_generic_sendmsg_iov_args {
    int       sd;
    struct iovec * iov;
    int       iovlen;
    caddr_t   to;
    socklen_t tolen;
    struct sctp_sndrcvinfo * sinfo;
    int       flags;
};
struct sctp_generic_recvmsg_args {
    int            sd;
    struct iovec * iov;
    int            iovlen;
    struct sockaddr * from;
    socklen_t *    fromlenaddr;
    struct sctp_sndrcvinfo * sinfo;
    int *          msg_flags;
};
#ifdef __SigloBSD__
struct socketduplicate_args {
    int          s;
    struct proc* owner_proc;
};
int sys_socketduplicate(struct thread*, struct socketduplicate_args *);
#endif
int sys_open(struct thread *, struct open_args *);
int sys_read(struct thread *, struct read_args *);
int sys_write(struct thread *, struct write_args *);
int sys_close(struct thread *, struct close_args *);
int sys_recvmsg(struct thread *, struct recvmsg_args *);
#ifdef __SigloBSD__
int sys_recvmmsg(struct thread *, struct recvmmsg_args *);
int sys_sendmmsg(struct thread *, struct sendmmsg_args *);
#endif
int sys_sendmsg(struct thread *, struct sendmsg_args *);
int sys_recvfrom(struct thread *, struct recvfrom_args *);
int sys_accept(struct thread *, struct accept_args *);
int sys_getpeername(struct thread *, struct getpeername_args *);
int sys_getsockname(struct thread *, struct getsockname_args *);
int sys_ioctl(struct thread *, struct ioctl_args *);
int sys_socket(struct thread *, struct socket_args *);
#ifdef __SigloBSD__
int sys_socket_exempt(struct thread *, struct socket_args *);
#endif
int sys_connect(struct thread *, struct connect_args *);
int sys_bind(struct thread *, struct bind_args *);
int sys_setsockopt(struct thread *, struct setsockopt_args *);
int sys_listen(struct thread *, struct listen_args *);
int sys_getsockopt(struct thread *, struct getsockopt_args *);
int sys_sendto(struct thread *, struct sendto_args *);
int sys_shutdown(struct thread *, struct shutdown_args *);
#ifdef __SigloBSD__
int sys_shutdown_all_helper(struct file* fp,int* count, int how, int forced);
#endif
int sys_select(struct thread *, struct select_args *);
int sys_poll(struct thread *, struct poll_args *);
int sys___sysctl(struct thread *, struct sysctl_args *);
#endif /* !_SYS_SYSPROTO_H_ */
