﻿
/*---------------------------------------------------------------------------*
  Copyright (C)2015 Nintendo Co., Ltd.  All rights reserved.

  These coded instructions, statements, and computer programs contain
  proprietary information of Nintendo of America Inc. and/or Nintendo
  Company Ltd., and are protected by Federal copyright law.  They may
  not be disclosed to third parties or copied or duplicated in any form,
  in whole or in part, without the prior written consent of Nintendo.
 *---------------------------------------------------------------------------*/

#pragma once

#if defined(__clang__)
#include <stddef.h>
#define __FBSDID(s)
#define __GNUCLIKE___SECTION
#define __POSIX_VISIBLE         200809
#define __dead2                 __attribute__((__noreturn__))
#define __pure2                 __attribute__((__const__))
#define __unused                __attribute__((__unused__))
#define __used                  __attribute__((__used__))
#define __section(x)            __attribute__((__section__(x)))
#define __nonnull(x)            __attribute__((__nonnull__(x)))
#define __func__                __FUNCTION__
#define __BSD_VISIBLE           1
#define __malloc_like           __attribute__((__malloc__))
#define __printflike(fmtarg, firstvararg) __attribute__((__format__ (__printf__, fmtarg, firstvararg)))
#define __DEVOLATILE(type, var) ((type)(uintptr_t)(volatile void *)(var))
#define __DECONST(type, var)    ((type)(uintptr_t)(const void *)(var))
#define __STRING(x)             #x
#define __XSTRING(x)            __STRING(x)
#define __predict_true(exp)     __builtin_expect((exp), 1)
#define __predict_false(exp)    __builtin_expect((exp), 0)
#endif

#include_next <sys/cdefs.h>

#ifdef _KERNEL

#define __CONCAT1(x,y)          x ## y
#define __CONCAT(x,y)           __CONCAT1(x,y)
#define __GLOBL1(sym)           __asm__(".globl " #sym)
#define __GLOBL(sym)            __GLOBL1(sym)

#endif
