﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#ifndef __FILE_SCOPE_MUTEX_H__
#define __FILE_SCOPE_MUTEX_H__

#if defined(__cplusplus)

#include <nn/os/os_MutexApi.h>

static nn::os::MutexType csmutex = NN_OS_MUTEX_INITIALIZER(1);
#define critical_enter() nn::os::LockMutex(&csmutex)
#define critical_exit()  nn::os::UnlockMutex(&csmutex)

#else

#include <nnc/os/os_MutexApi.h>

static nnosMutexType csmutex = NN_OS_MUTEX_INITIALIZER(1);
#define critical_enter() nnosLockMutex(&csmutex)
#define critical_exit()  nnosUnlockMutex(&csmutex)

#endif




#endif // __FILE_SCOPE_MUTEX_H__
