﻿
#ifndef _BSD_INCLUDE_PARAM_H_
#define _BSD_INCLUDE_PARAM_H_

#if defined(SMP)
#ifndef SMP_CPU_MASK
#define SMP_CPU_MASK        ((1<<3) | (1<<2) | (1<<1) | (1<<0))
#endif
#ifndef MAXCPU
#define MAXCPU              4
#endif
#else
#define SMP_CPU_MASK        (1<<0)
#define MAXCPU              1
#endif /* SMP */

#define ALIGNBYTES          _ALIGNBYTES
#define ALIGN(p)            _ALIGN(p)

/*
 * CACHE_LINE_SIZE is the compile-time maximum cache line size for an
 * architecture.  It should be used with appropriate caution.
 */
#define CACHE_LINE_SHIFT    6
#define CACHE_LINE_SIZE     (1 << CACHE_LINE_SHIFT)

#ifdef PAGE_SIZE
#undef PAGE_SIZE
#endif

#define PAGE_SHIFT          12
#define PAGE_SIZE           (1 << PAGE_SHIFT)    /* Page size */
#define PAGE_MASK           (PAGE_SIZE - 1)

/*
 * Mach derived conversion macros
 */
#define trunc_page(x)       ((x) & ~PAGE_MASK)
#define round_page(x)       (((x) + PAGE_MASK) & ~PAGE_MASK)

#include      <machine/endian.h>

#endif /* !_BSD_INCLUDE_PARAM_H_ */
