﻿/*---------------------------------------------------------------------------*
  Copyright (C)2015 Nintendo Co., Ltd.  All rights reserved.

  These coded instructions, statements, and computer programs contain
  proprietary information of Nintendo of America Inc. and/or Nintendo
  Company Ltd., and are protected by Federal copyright law.  They may
  not be disclosed to third parties or copied or duplicated in any form,
  in whole or in part, without the prior written consent of Nintendo.
 *---------------------------------------------------------------------------*/

#pragma once


#if defined(__cplusplus)
extern "C"
{
#endif

#define ETH_IF_DRV_LOG_INFO(format,...) \
   eth_if_drv_log("[eth_if_drv] info: " format, ##__VA_ARGS__)

#define ETH_IF_DRV_LOG_ERROR(format,...) \
   eth_if_drv_log("[eth_if_drv] error: " format, ##__VA_ARGS__)

#define ETH_IF_DRV_CHECK_RV_ERROR(rv)                                           \
    if((rv)<0) {                                                                \
       eth_if_drv_log("[eth_if_drv] error: file=%s, func=%s(), status=%d.\n",   \
                      __FILE__,__func__,(rv));}

/* Interface prototypes for eth_if_drv.cpp */
int eth_if_drv_finalize();
bool eth_if_drv_send(int queued, const unsigned char *segment_buffers[], size_t segment_sizes[]);
void eth_if_drv_log(const char * format, ...);

/* Interface prototypes for eth_if_drv_c.c */
int eth_if_drv_attach(const unsigned char *macaddress);
int eth_if_drv_detach();
void eth_if_drv_linkup();
void eth_if_drv_linkdown();
void eth_if_drv_send_complete();
void eth_if_drv_receive_frame(const void *frame, size_t size);

#if defined(__cplusplus)
}
#endif








