/*-----------------------------------------------------------------------*
  Project: csGrass
  File: transform.vs

  Copyright (C) 2013 Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain
  proprietary information of Nintendo and/or its licensed developers
  and are protected by national and international copyright laws. They
  may not be disclosed to third parties or copied or duplicated in any
  form, in whole or in part, without the prior written consent of
  Nintendo.

  The content herein is highly confidential and should be handled
  accordingly.
*-----------------------------------------------------------------------*/
#version 330
attribute vec4 a_position;
attribute vec4 a_color;

layout(std140) uniform u_InstancedMV {
    struct {
        vec4 u_modelviewMtx0;
        vec4 u_modelviewMtx1;
        vec4 u_modelviewMtx2;
        vec4 u_modelviewMtx3;
    } mv[25];					// MaxFieldInstances from main.cpp
};

layout(std140) uniform u_VUniforms
{
	mat4 u_projMtx;
};

varying vec4 v_color;

void main()
{
    mat4 modelviewMtx = mat4( mv[gl_InstanceID].u_modelviewMtx0, 
							  mv[gl_InstanceID].u_modelviewMtx1, 
							  mv[gl_InstanceID].u_modelviewMtx2, 
							  mv[gl_InstanceID].u_modelviewMtx3); 
    v_color = a_color;

    // Matrix data is column-major
    gl_Position = u_projMtx * modelviewMtx * a_position;
}
