﻿/* $Id$ */

/* vscanf( const char *, va_list arg )

   This file is part of the Public Dotest_vscanf C Library (PDCLib).
   Permission is granted to use, modify, and / or redistribute at will.
*/

#include <stdio.h>
#include <stdarg.h>


#define _PDCLIB_FILEID "stdio/vscanf.c"
#define _PDCLIB_FILEIO

#include "pdclib-tests/pdclib-tests.h"

static int testscanf( FILE * stream, const char * format, ... )
{
    int i;
    va_list arg;
    va_start( arg, format );
    i = vscanf( format, arg );
    va_end( arg );
    return i;
}

int test_vscanf( void )
{
    FILE * source;
    TESTCASE( ( source = freopen( testfile, "wb+", stdin ) ) != NULL );
#include "scanf_testcases.h"
    TESTCASE( fclose( source ) == 0 );
    TESTCASE( remove( testfile ) == 0 );
    return TEST_RESULTS;
}

