﻿/* $Id$ */

/* vprintf( const char *, va_list arg )

   This file is part of the Public Dotest_vprintf C Library (PDCLib).
   Permission is granted to use, modify, and / or redistribute at will.
*/

#include <stdio.h>
#include <stdarg.h>


#define _PDCLIB_FILEID "stdio/vprintf.c"
#define _PDCLIB_FILEIO
#include <stdint.h>
#include <stddef.h>
#include "pdclib-tests/pdclib-tests.h"

static int testprintf( FILE * stream, const char * format, ... )
{
    int i;
    va_list arg;
    va_start( arg, format );
    i = vprintf( format, arg );
    va_end( arg );
    return i;
}

int test_vprintf( void )
{
    FILE * target;
    TESTCASE( ( target = freopen( testfile, "wb+", stdout ) ) != NULL );
#include "pdclib-tests/printf_testcases.h"
    TESTCASE( fclose( target ) == 0 );
    TESTCASE( remove( testfile ) == 0 );
    return TEST_RESULTS;
}

