﻿/* $Id$ */

/* vfscanf( FILE *, const char *, va_list )

   This file is part of the Public Dotest_vfscanf C Library (PDCLib).
   Permission is granted to use, modify, and / or redistribute at will.
*/

#include <stdio.h>
#include <stdarg.h>
#include <ctype.h>


#define _PDCLIB_FILEID "stdio/vfscanf.c"
#define _PDCLIB_FILEIO

#include "pdclib-tests/pdclib-tests.h"

static int testscanf( FILE * stream, char const * format, ... )
{
    va_list ap;
    va_start( ap, format );
    int result = vfscanf( stream, format, ap );
    va_end( ap );
    return result;
}

int test_vfscanf( void )
{
    FILE * source;
    TESTCASE( ( source = tmpfile() ) != NULL );
#include "pdclib-tests/scanf_testcases.h"
    TESTCASE( fclose( source ) == 0 );
    return TEST_RESULTS;
}


