﻿/* $Id$ */

/* gets( char * )

   This file is part of the Public Dotest_gets C Library (PDCLib).
   Permission is granted to use, modify, and / or redistribute at will.
*/


/* gets() is deprecated as of __STDC_VERSION__ 201112L
 *
  * enable by defining __STDC_VERSION__
 */
#ifdef __STDC_VERSION__
#undef __STDC_VERSION__
#endif
#define __STDC_VERSION__ 199900L

#include <stdio.h>

/* there are several warnings that you will get because musl doesn't provide a prototype for gets with C11 */

#include "pdclib-tests/pdclib-tests.h"
#include <string.h>

int test_gets( void )
{
    FILE * fh;
    char buffer[10];
    char const * gets_test = "foo\nbar\0baz\nweenie";
    TESTCASE( ( fh = fopen( testfile, "wb" ) ) != NULL );
    TESTCASE( fwrite( gets_test, 1, 18, fh ) == 18 );
    TESTCASE( fclose( fh ) == 0 );
    TESTCASE( ( fh = freopen( testfile, "rb", stdin ) ) != NULL );
    TESTCASE( gets( buffer ) == buffer );
    TESTCASE( strcmp( buffer, "foo" ) == 0 );
    TESTCASE( gets( buffer ) == buffer );
    TESTCASE( memcmp( buffer, "bar\0baz\0", 8 ) == 0 );
    TESTCASE( gets( buffer ) == buffer );
    TESTCASE( strcmp( buffer, "weenie" ) == 0 );
    TESTCASE( feof( fh ) );
    TESTCASE( fseek( fh, -1, SEEK_END ) == 0 );
    TESTCASE( gets( buffer ) == buffer );
    TESTCASE( strcmp( buffer, "e" ) == 0 );
    TESTCASE( feof( fh ) );
    TESTCASE( fseek( fh, 0, SEEK_END ) == 0 );
    TESTCASE( gets( buffer ) == NULL );
    TESTCASE( fclose( fh ) == 0 );
    TESTCASE( remove( testfile ) == 0 );
    return TEST_RESULTS;
}


