﻿/* $Id$ */

/* lldiv( long long int, long long int )

   This file is part of the Public Dotest_imaxdiv C Library (PDCLib).
   Permission is granted to use, modify, and / or redistribute at will.
*/

#include <inttypes.h>


#include "pdclib-tests/pdclib-tests.h"

int test_imaxdiv( void )
{
    imaxdiv_t result;
    result = imaxdiv( (intmax_t)5, (intmax_t)2 );
    TESTCASE( result.quot == 2 && result.rem == 1 );
    result = imaxdiv( (intmax_t)-5, (intmax_t)2 );
    TESTCASE( result.quot == -2 && result.rem == -1 );
    result = imaxdiv( (intmax_t)5, (intmax_t)-2 );
    TESTCASE( result.quot == -2 && result.rem == 1 );
    TESTCASE( sizeof( result.quot ) == sizeof( intmax_t ) );
    TESTCASE( sizeof( result.rem )  == sizeof( intmax_t ) );
    return TEST_RESULTS;
}

