﻿/*---------------------------------------------------------------------------*
  Copyright (C)2015 Nintendo Co., Ltd.  All rights reserved.

  These coded instructions, statements, and computer programs contain
  proprietary information of Nintendo of America Inc. and/or Nintendo
  Company Ltd., and are protected by Federal copyright law.  They may
  not be disclosed to third parties or copied or duplicated in any form,
  in whole or in part, without the prior written consent of Nintendo.
 *---------------------------------------------------------------------------*/

#include "thread_test.h"
/* The header above includes other headers this file needs:
     #include <stdio.h>
*/
#include <errno.h>
#include <semaphore.h>

#include "ntd-tests/ntd-tests.h"

void test_sem_trywait()
{
    sem_t sem;
    int cur_value;
    int rc;

    NTD_TEST_GROUP_START("sem_trywait", 3);

    rc = sem_init(&sem, 0, 1);
    TESTCASE_MESSAGE(rc == 0, "sem_init(%p) returned %d expected 0", &sem, rc);

    rc = sem_getvalue(&sem, &cur_value);
    TESTCASE_MESSAGE(rc == 0, "sem_getvalue(%p) returned %d expected 0", &sem, rc);

    TESTWARN("After sem_init() the value of the semaphore is %d\n", cur_value);

    rc = sem_wait(&sem);
    TESTCASE_MESSAGE(rc == 0, "sem_wait(%p) returned %d expected 0", &sem, rc);

    rc = sem_getvalue(&sem, &cur_value);
    TESTCASE_MESSAGE(rc == 0, "sem_getvalue(%p, %p) returned %d expected 0",
        &sem, &cur_value, rc);

    TESTWARN("After sem_wait() the value of the semaphore is %d\n", cur_value);

    errno = 0;
    rc = sem_trywait(&sem);
    TESTCASE_MESSAGE(((rc == -1) && (errno == EAGAIN)),
        "sem_trywait(%p) returned %d expected failure and errno (%d) == EAGAIN(%d)",
        &sem, rc, errno, EAGAIN);

    rc = sem_getvalue(&sem, &cur_value);
    TESTCASE_MESSAGE(rc == 0, "sem_getvalue(%p, %p) returned %d expected 0",
        &sem, &cur_value, rc);

    TESTWARN("After sem_trywait() the value of the semaphore is %d\n", cur_value);

    rc = sem_destroy(&sem);
    TESTCASE_MESSAGE(rc == 0, "sem_destroy(%p) returned %d expected 0", &sem, rc);

    NTD_TEST_GROUP_END("sem_trywait", 3);
}

#if 0
Debug output:

Enter Testcase - sem_trywait_example
After sem_init() the value of the semaphore is 1
After sem_wait() the value of the semaphore is 0
sem_trywait() could not obtain a lock
After sem_trywait() the value of the semaphore is 0
sem_trywait_example completed
#endif
