﻿/*---------------------------------------------------------------------------*
  Copyright (C)2015 Nintendo Co., Ltd.  All rights reserved.

  These coded instructions, statements, and computer programs contain
  proprietary information of Nintendo of America Inc. and/or Nintendo
  Company Ltd., and are protected by Federal copyright law.  They may
  not be disclosed to third parties or copied or duplicated in any form,
  in whole or in part, without the prior written consent of Nintendo.
 *---------------------------------------------------------------------------*/

#include "thread_test.h"
/* The header above includes other headers this file needs:
     #include <stdio.h>
*/
#include <pthread.h>
#include <errno.h>

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */
  #include "ntd-tests/ntd-tests.h"
#ifdef __cplusplus
}
#endif /* __cplusplus */

#define            LOOPCONSTANT     1000
#define            THREADS          3

#if SUPPORT_STATIC_INITALIZATION
static pthread_mutex_t    mutex = PTHREAD_MUTEX_INITIALIZER;
#else
static pthread_mutex_t    mutex;
#endif
static int                i,j,k,l;

typedef struct thread_info {
    pthread_t           threadid;
    char                name[16];
} thread_info;
static thread_info      threads[THREADS];

static void *threadfunc(void *parm)
{
  int   loop = 0, i;
  int   rc;
  int   lock_failures = 0;
  int   unlock_failures = 0;

  pthread_t me = pthread_self();
  char *name = (char *)"Can not find thread";

  for (i = 0; i < THREADS; i++) {
    if (threads[i].threadid == me) {
        name = threads[i].name;
        break;
    }
  }

  TESTWARN("Entered secondary \"%s\"\n", name);

  for (loop=0; loop<LOOPCONSTANT; ++loop) {
    rc = pthread_mutex_lock(&mutex);
    if (rc != 0) {
        if (lock_failures == 0) {
            TESTCASE_MESSAGE(rc == 0, "pthread_mutex_lock() returned %d", rc);
        }
        lock_failures++;
    }
    /* Perform some not so important processing */
    i++, j++, k++, l++;

    rc = pthread_mutex_unlock(&mutex);
    if (rc != 0) {
        if (unlock_failures == 0) {
            TESTCASE_MESSAGE(rc == 0, "pthread_mutex_unlock() returned %d", rc);
        }
        unlock_failures++;
    }
    /* This work is not too important. Also, we just released a lock
       and would like to ensure that other threads get a chance in
       a more co-operative manner. This is an admittedly contrived
       example with no real purpose for doing the sched_yield().
       */
    sched_yield();
  }
  TESTCASE_MESSAGE(lock_failures == 0 && unlock_failures == 0, "%d lock failures, %d unlock failures",
    lock_failures, unlock_failures);

  TESTWARN("Finished secondary \"%s\"\n", name);

  return NULL;
}

void test_sched_yield()
{
  int                   rc=0;
  int                   loop=0;

  NTD_TEST_GROUP_START("sched_yield", 3);

#if !SUPPORT_STATIC_INITALIZATION
  rc = pthread_mutex_init(&mutex, NULL);
  TESTCASE_MESSAGE(rc == 0, "pthread_mutex_init(NULL) returned %d expected 0", rc);
#endif
  rc = pthread_mutex_lock(&mutex);
  TESTCASE_MESSAGE(rc == 0, "pthread_mutex_lock() returned %d expected 0", rc);

  TESTWARN("Creating %d threads\n", THREADS);
  for (loop=0; loop<THREADS; ++loop) {
    rc = pthread_create(&(threads[loop].threadid), NULL, threadfunc, NULL);
    sprintf(threads[loop].name, "thread %d", loop);
    TESTCASE_MESSAGE(rc == 0, "pthread_create() returned %d expected 0", rc);
  }

  sleep(1);
  rc = pthread_mutex_unlock(&mutex);
  TESTCASE_MESSAGE(rc == 0, "pthread_mutex_unlock() returned %d expected 0", rc);

  TESTWARN("Wait for results\n");
  for (loop=0; loop<THREADS; ++loop) {
    rc = pthread_join(threads[loop].threadid, NULL);
    TESTCASE_MESSAGE(rc == 0, "pthread_join() returned %d expected 0", rc);
  }

  pthread_mutex_destroy(&mutex);
  NTD_TEST_GROUP_END("sched_yield", 3);
}

#if 0
Debug output:

Enter Testcase - QP0WTEST/TPSCHY0
Creating 3 threads
Entered secondary thread
Entered secondary thread

Entered secondary thread
Wait for results
Finished secondary thread
Finished secondary thread
Finished secondary thread
Main completed
#endif
