﻿/*---------------------------------------------------------------------------*
  Copyright (C)2015 Nintendo Co., Ltd.  All rights reserved.

  These coded instructions, statements, and computer programs contain
  proprietary information of Nintendo of America Inc. and/or Nintendo
  Company Ltd., and are protected by Federal copyright law.  They may
  not be disclosed to third parties or copied or duplicated in any form,
  in whole or in part, without the prior written consent of Nintendo.
 *---------------------------------------------------------------------------*/

#include "thread_test.h"
/* The header above includes other headers this file needs:
     #include <stdio.h>
     #include <unistd.h>
*/
#include <sched.h>

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */
  #include "ntd-tests/ntd-tests.h"
#ifdef __cplusplus
}
#endif /* __cplusplus */

#if defined(__NX__)
  #include <nnc/os.h>
#endif

void test_sched_get_priority_max()
{
    int min, max, bad_result;
    char *policy_str;
    int policy;
    bool test1, test2;
    NTD_TEST_GROUP_START("get_priority_max", 3);
#if defined(__NX__)
    bad_result = NN_OS_THREAD_PRIORITY_RANGE_SIZE - NN_OS_DEFAULT_THREAD_PRIORITY;
#else
    bad_result = 99999999;
#endif

    TESTWARN("Lower numbers are higher priorities and v.v.\n");
    policy = SCHED_OTHER;
    policy_str = (char *)"SCHED_OTHER";
    max = sched_get_priority_max(policy);
    min = sched_get_priority_min(policy);

    test1 = (min != bad_result);  TESTCASE( test1 );
    test2 = (max != bad_result);  TESTCASE( test2 );
    if (test1 && test2) {
        TESTWARN("Valid max and min priorities for %s: %d to %d\n", policy_str, max, min);
    } else {
        TESTWARN("max and min priorities are unsupported for policy %s\n", policy_str);
    }

    policy = SCHED_FIFO;
    policy_str = (char *)"SCHED_FIFO";
    max = sched_get_priority_max(policy);
    min = sched_get_priority_min(policy);

    test1 = (min != bad_result);  TESTCASE( test1 );
    test2 = (max != bad_result);  TESTCASE( test2 );
    if (test1 && test2) {
        TESTWARN("Valid max and min priorities for %s: %d to %d\n", policy_str, max, min);
    } else {
        TESTWARN("max and min priorities are unsupported for policy %s\n", policy_str);
    }
#if TEST_UNSUPPORTED_FEATURES
    policy = SCHED_RR;
    policy_str = (char *)"SCHED_RR";
    max = sched_get_priority_max(policy);
    min = sched_get_priority_min(policy);

    test1 = (min != bad_result);  TESTCASE( test1 );
    test2 = (max != bad_result);  TESTCASE( test2 );
    if (test1 && test2) {
        TESTWARN("Valid max and min priorities for %s: %d to %d\n", policy_str, max, min);
    } else {
        TESTWARN("max and min priorities are unsupported for policy %s\n", policy_str);
    }
#endif

  NTD_TEST_GROUP_END("get_priority_max", 3);
}
