﻿/*---------------------------------------------------------------------------*
  Copyright (C)2017 Nintendo Co., Ltd.  All rights reserved.

  These coded instructions, statements, and computer programs contain
  proprietary information of Nintendo of America Inc. and/or Nintendo
  Company Ltd., and are protected by Federal copyright law.  They may
  not be disclosed to third parties or copied or duplicated in any form,
  in whole or in part, without the prior written consent of Nintendo.
 *---------------------------------------------------------------------------*/

#include "thread_test.h"
/* The header above includes other headers this file needs:
     #include <stdio.h>
     #include <pthread.h>
     #include <unistd.h>
*/

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */
  #include "ntd-tests/ntd-tests.h"
#ifdef __cplusplus
}
#endif /* __cplusplus */

static pthread_rwlock_t rwlock;

void *rdlockThread(void *arg)
{
  int rc;

  rc = pthread_rwlock_rdlock(&rwlock);
  TESTCASE_MESSAGE(rc == 0, "pthread_rwlock_rdlock() returned errno %d (%s) expected 0", rc, strerror(rc));

  sleep(5);

  rc = pthread_rwlock_unlock(&rwlock);
  TESTCASE_MESSAGE(rc == 0, "pthread_rwlock_unlock() returned errno %d (%s) expected 0", rc, strerror(rc));
  return NULL;
}

void *wrlockThread(void *arg)
{
  int rc;

  rc = pthread_rwlock_wrlock(&rwlock);
  TESTCASE_MESSAGE(rc == 0, "pthread_rwlock_wrlock() returned errno %d (%s) expected 0", rc, strerror(rc));

  rc = pthread_rwlock_unlock(&rwlock);
  TESTCASE_MESSAGE(rc == 0, "pthread_rwlock_unlock() returned errno %d (%s) expected 0", rc, strerror(rc));
  return NULL;
}

void test_pthread_rwlock_basic()
{
  pthread_t thread1, thread2;
  int rc = 0;
  void *status;
  bool test;

  NTD_TEST_GROUP_START("pthread_rwlock_basic", 3);

  rc = pthread_rwlock_init(&rwlock, NULL);
  TESTCASE_MESSAGE(rc == 0, "pthread_rwlock_init() returned errno %d (%s) expected 0", rc, strerror(rc));

  rc = pthread_rwlock_rdlock(&rwlock);
  TESTCASE_MESSAGE(rc == 0, "pthread_rwlock_rdlock() returned errno %d (%s) expected 0", rc, strerror(rc));

  rc = pthread_rwlock_rdlock(&rwlock);
  TESTCASE_MESSAGE(rc == 0, "pthread_rwlock_rdlock() returned errno %d (%s) expected 0", rc, strerror(rc));

  rc = pthread_create(&thread1, NULL, rdlockThread, NULL);
  TESTCASE_MESSAGE(rc == 0, "pthread_create() returned %d expected 0", rc);

  rc = pthread_rwlock_unlock(&rwlock);
  TESTCASE_MESSAGE(rc == 0, "pthread_rwlock_unlock() returned errno %d (%s) expected 0", rc, strerror(rc));

  rc = pthread_create(&thread2, NULL, wrlockThread, NULL);
  TESTCASE_MESSAGE(rc == 0, "pthread_create() returned %d expected 0", rc);

  sleep(5);

  rc = pthread_rwlock_unlock(&rwlock);
  TESTCASE_MESSAGE(rc == 0, "pthread_rwlock_unlock() returned errno %d (%s) expected 0", rc, strerror(rc));

  rc = pthread_join(thread1, NULL);
  TESTCASE_MESSAGE(rc == 0, "pthread_join() returned %d expected 0", rc);

  rc = pthread_join(thread2, NULL);
  TESTCASE_MESSAGE(rc == 0, "pthread_join() returned %d expected 0", rc);

  rc = pthread_rwlock_destroy(&rwlock);
  TESTCASE_MESSAGE(rc == 0, "pthread_rwlock_destroy() returned errno %d (%s) expected 0", rc, strerror(rc));

  NTD_TEST_GROUP_END("pthread_rwlock_basic", 3);
}
