﻿/*---------------------------------------------------------------------------*
  Copyright (C)2015 Nintendo Co., Ltd.  All rights reserved.

  These coded instructions, statements, and computer programs contain
  proprietary information of Nintendo of America Inc. and/or Nintendo
  Company Ltd., and are protected by Federal copyright law.  They may
  not be disclosed to third parties or copied or duplicated in any form,
  in whole or in part, without the prior written consent of Nintendo.
 *---------------------------------------------------------------------------*/

#include "thread_test.h"
/* The header above includes other headers this file needs:
     #include <stdio.h>
*/
#include <pthread.h>
#include <sched.h>

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */
  #include "ntd-tests/ntd-tests.h"
#ifdef __cplusplus
}
#endif /* __cplusplus */

static void showMutexType(pthread_mutexattr_t *a, int set_type, char *set_type_str)
{
    int                 rc=0;
    int                 type;
    char *              type_str;

    rc = pthread_mutexattr_gettype(a, &type);
    TESTCASE_MESSAGE(rc == 0, "pthread_mutexattr_gettype() returned %d expected 0", rc);

    if (!rc) {
        if (type == PTHREAD_MUTEX_NORMAL) {
            type_str = (char *)"PTHREAD_MUTEX_NORMAL";
        } else if (type == PTHREAD_MUTEX_DEFAULT) {
            type_str = (char *)"PTHREAD_MUTEX_DEFAULT";
        } else if (type == PTHREAD_MUTEX_RECURSIVE) {
            type_str = (char *)"PTHREAD_MUTEX_RECURSIVE";
#if TEST_UNSUPPORTED_FEATURES
        } else if (type == PTHREAD_MUTEX_ERRORCHECK) {
            type_str = (char *)"PTHREAD_MUTEX_ERRORCHECK";
#endif
        } else {
            type_str = (char *)"UNKNOWN_MUTEX_TYPE";
        }
        if (type != set_type) {
            TESTWARN("Failure: expected mutex type %s but pthread_mutexattr_gettype returned %s\n",
                set_type_str, type_str);
        } else {
            TESTWARN("pthread_mutexattr_gettype returned the expected mutex type: %s\n", type_str);
        }
    }
}

void test_pthread_mutexattr_settype()
{
    int                   rc=0;
    pthread_mutexattr_t   pma;
    bool                  test;

    NTD_TEST_GROUP_START("mutexattr_settype", 3);

    TESTWARN("Create a mutex attributes object\n");
    rc = pthread_mutexattr_init(&pma);
    TESTCASE_MESSAGE(rc == 0, "pthread_mutexattr_init() returned %d expected 0", rc);

    if (!rc) {
        showMutexType(&pma, 0, (char *)"PTHREAD_MUTEX_NORMAL");
    } else {
        TESTWARN("Failed calling pthread_mutexattr_init\n");
    }

    rc = pthread_mutexattr_init(&pma);
    TESTCASE_MESSAGE(rc == 0, "pthread_mutexattr_init() returned %d expected 0", rc);

    TESTWARN("Setting mutex to PTHREAD_MUTEX_NORMAL\n");
    rc = pthread_mutexattr_settype(&pma, PTHREAD_MUTEX_NORMAL);
    TESTCASE_MESSAGE(rc == 0, "pthread_mutexattr_settype() returned %d expected 0", rc);
    if (!rc) {
        showMutexType(&pma, PTHREAD_MUTEX_NORMAL, (char *)"PTHREAD_MUTEX_NORMAL");
    } else {
        TESTWARN("Failed passing %s for mutex type\n", "PTHREAD_MUTEX_NORMAL");
    }

    rc = pthread_mutexattr_init(&pma);
    TESTCASE_MESSAGE(rc == 0, "pthread_mutexattr_init() returned %d expected 0", rc);

    TESTWARN("Setting mutex to PTHREAD_MUTEX_DEFAULT\n");
    rc = pthread_mutexattr_settype(&pma, PTHREAD_MUTEX_DEFAULT);
    TESTCASE_MESSAGE(rc == 0, "pthread_mutexattr_settype() returned %d expected 0", rc);
    if (!rc) {
        showMutexType(&pma, PTHREAD_MUTEX_DEFAULT, (char *)"PTHREAD_MUTEX_DEFAULT");
    } else {
        TESTWARN("Failed passing %s for mutex type\n", "PTHREAD_MUTEX_DEFAULT");
    }

    rc = pthread_mutexattr_init(&pma);
    TESTCASE_MESSAGE(rc == 0, "pthread_mutexattr_init() returned %d expected 0", rc);

    TESTWARN("Setting mutex to PTHREAD_MUTEX_RECURSIVE\n");
    rc = pthread_mutexattr_settype(&pma, PTHREAD_MUTEX_RECURSIVE);
    TESTCASE_MESSAGE(rc == 0, "pthread_mutexattr_settype() returned %d expected 0", rc);
    if (!rc) {
        showMutexType(&pma, PTHREAD_MUTEX_RECURSIVE, (char *)"PTHREAD_MUTEX_RECURSIVE");
    } else {
        TESTWARN("Failed passing %s for mutex type\n", "PTHREAD_MUTEX_RECURSIVE");
    }

    rc = pthread_mutexattr_init(&pma);
    TESTCASE_MESSAGE(rc == 0, "pthread_mutexattr_init() returned %d expected 0", rc);

#if TEST_UNSUPPORTED_FEATURES
    TESTWARN("Setting mutex to PTHREAD_MUTEX_ERRORCHECK\n");
    rc = pthread_mutexattr_settype(&pma, PTHREAD_MUTEX_ERRORCHECK);
    if (rc == EINVAL) {
        TESTWARN("tried an unsupported mutex type and got the expected error 0x%x (this message is OK)\n", rc, __FILE__, __LINE__);
    } else if (rc) {
        TESTWARN("Unexpected error: passing %s for unsupported mutex type returned 0x%x\n", "PTHREAD_MUTEX_ERRORCHECK", rc, __FILE__, __LINE__);
    } else {
        TESTWARN("Unexpected success: passing %s for unsupported mutex type returned no error (this message is not OK)\n", "PTHREAD_MUTEX_ERRORCHECK");
        showMutexType(&pma, PTHREAD_MUTEX_ERRORCHECK, (char *)"PTHREAD_MUTEX_ERRORCHECK");
    }
#endif

    rc = pthread_mutexattr_init(&pma);
    TESTCASE_MESSAGE(rc == 0, "pthread_mutexattr_init() returned %d expected 0", rc);

#if TEST_UNSUPPORTED_FEATURES
    TESTWARN("Setting scope to 3\n");
    rc = pthread_mutexattr_settype(&pma, 3);
    test = (rc == EINVAL);
    TESTCASE( test );
    if (test) {
        TESTWARN("tried an unsupported mutex type and got the expected error 0x%x (this message is OK)\n", rc, __FILE__, __LINE__);
    } else if (rc) {
        TESTWARN("Unexpected error: passing %s for unsupported mutex type returned 0x%x\n", "3", rc, __FILE__, __LINE__);
    } else {
        TESTWARN("Unexpected success: passing %s for unsupported mutex type returned no error (this message is not OK)\n", "3");
        showMutexType(&pma, 3, (char *)"3");
    }
#endif

    TESTWARN("Destroy mutex attributes object\n");
    rc = pthread_mutexattr_destroy(&pma);
    TESTCASE_MESSAGE(rc == 0, "pthread_mutexattr_destroy() returned %d expected 0", rc);

    NTD_TEST_GROUP_END("mutexattr_settype", 3);
}
