﻿/*---------------------------------------------------------------------------*
  Copyright (C)2015 Nintendo Co., Ltd.  All rights reserved.

  These coded instructions, statements, and computer programs contain
  proprietary information of Nintendo of America Inc. and/or Nintendo
  Company Ltd., and are protected by Federal copyright law.  They may
  not be disclosed to third parties or copied or duplicated in any form,
  in whole or in part, without the prior written consent of Nintendo.
 *---------------------------------------------------------------------------*/

#include "thread_test.h"
/* The header above includes other headers this file needs:
     #include <stdio.h>
*/
#include <pthread.h>
#include <sched.h>

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */
  #include "ntd-tests/ntd-tests.h"
#ifdef __cplusplus
}
#endif /* __cplusplus */

static pthread_key_t        tlsKey = 0;

static void globalDestructor(void *value)
{
  TESTWARN("In the data destructor\n");
  free(value);
  pthread_setspecific(tlsKey, NULL);
}


void test_pthread_key_create()
{
  int                   rc=0;

  NTD_TEST_GROUP_START("key_create", 3);

  TESTWARN("Create a thread local storage key\n");
  rc = pthread_key_create(&tlsKey, globalDestructor);
  TESTCASE_MESSAGE(rc == 0, "pthread_key_create() returned %d expected 0", rc);
  /* The key can now be used from all threads */

  TESTWARN("- The key can now be used from all threads\n");
  TESTWARN("- in the process to storage thread local\n");
  TESTWARN("- (but global to all functions in that thread)\n");
  TESTWARN("- storage\n");

  TESTWARN("Delete a thread local storage key\n");
  rc = pthread_key_delete(tlsKey);
  TESTCASE_MESSAGE(rc == 0, "pthread_key_delete() returned %d expected 0", rc);
  /* The key and any remaining values are now gone. */
  NTD_TEST_GROUP_END("key_create", 3);
}

#if 0
Debug output:

Enter Testcase - QP0WTEST/TPKEYC0
Create a thread local storage key
- The key can now be used from all threads
- in the process to storage thread local
- (but global to all functions in that thread)
- storage
Delete a thread local storage key
Main completed
#endif
