﻿/*---------------------------------------------------------------------------*
  Copyright (C)2015 Nintendo Co., Ltd.  All rights reserved.

  These coded instructions, statements, and computer programs contain
  proprietary information of Nintendo of America Inc. and/or Nintendo
  Company Ltd., and are protected by Federal copyright law.  They may
  not be disclosed to third parties or copied or duplicated in any form,
  in whole or in part, without the prior written consent of Nintendo.
 *---------------------------------------------------------------------------*/

#include "thread_test.h"
/* The header above includes other headers this file needs:
     #include <stdio.h>
*/
#include <pthread.h>
#include "ntd-tests/ntd-tests.h"
#include <unistd.h>

/* For safe condition variable usage, must use a boolean predicate and   */
/* a mutex with the condition.                                           */
static int                 conditionMet = 0;
#if SUPPORT_STATIC_INITALIZATION
static pthread_cond_t      cond  = PTHREAD_COND_INITIALIZER;
static pthread_mutex_t     mutex = PTHREAD_MUTEX_INITIALIZER;
#else
static pthread_cond_t      cond;
static pthread_mutex_t     mutex;
#endif

#define NTHREADS    5

typedef struct thread_info {
    pthread_t           threadid;
    char                name[16];
} thread_info;
static thread_info      threads[NTHREADS];

static void *threadfunc(void *parm)
{
  int           rc, i;
  pthread_t     me = pthread_self();
  char          *name = (char *)"Can not find thread";

  for (i = 0; i < NTHREADS; i++) {
    if (threads[i].threadid == me) {
        name = threads[i].name;
        break;
    }
  }

  rc = pthread_mutex_lock(&mutex);
  TESTCASE_MESSAGE(rc == 0, "pthread_mutex_lock() returned %d expected 0", rc);

  while (!conditionMet) {
    TESTWARN("%s blocked\n", name);
    rc = pthread_cond_wait(&cond, &mutex);
    TESTCASE_MESSAGE(rc == 0, "pthread_cond_wait() returned %d expected 0", rc);
  }

  rc = pthread_mutex_unlock(&mutex);
  TESTCASE_MESSAGE(rc == 0, "pthread_mutex_lock() returned %d expected 0", rc);
  return NULL;
}

void test_pthread_cond_wait()
{
  int                   rc=0;
  int                   i;

  NTD_TEST_GROUP_START("cond_wait", 3);

#if !SUPPORT_STATIC_INITALIZATION
  rc = pthread_cond_init(&cond, NULL);
  TESTCASE_MESSAGE(rc == 0, "pthread_cond_init() returned %d expected 0", rc);

  rc = pthread_mutex_init(&mutex, NULL);
  TESTCASE_MESSAGE(rc == 0, "pthread_mutex_init(NULL) returned %d expected 0", rc);
#endif

  TESTWARN("Create %d threads\n", NTHREADS);
  for(i=0; i<NTHREADS; ++i) {
    rc = pthread_create(&(threads[i].threadid), NULL, threadfunc, NULL);
    sprintf(threads[i].name, "thread %d", i);
    TESTCASE_MESSAGE(rc == 0, "pthread_create() returned %d expected 0", rc);
  }

  usleep(5000);  /* Sleep is not a very robust way to serialize threads */
  rc = pthread_mutex_lock(&mutex);
  TESTCASE_MESSAGE(rc == 0, "pthread_mutex_lock() returned %d expected 0", rc);

  /* The condition has occured. Set the flag and wake up any waiting threads */
  conditionMet = 1;
  TESTWARN("Wake up all waiting threads...\n");
  rc = pthread_cond_broadcast(&cond);
  TESTCASE_MESSAGE(rc == 0, "pthread_cond_broadcast() returned %d expected 0", rc);

  rc = pthread_mutex_unlock(&mutex);
  TESTCASE_MESSAGE(rc == 0, "pthread_mutex_unlock() returned %d expected 0", rc);

  TESTWARN("Wait for threads and cleanup\n");
  for (i=0; i<NTHREADS; ++i) {
    rc = pthread_join(threads[i].threadid, NULL);
    TESTCASE_MESSAGE(rc == 0, "pthread_join() returned %d expected 0", rc);
  }
  pthread_cond_destroy(&cond);
  pthread_mutex_destroy(&mutex);

  NTD_TEST_GROUP_END("cond_wait", 3);
}

#if 0
Debug output:

Entering testcase
Create 5 threads
Thread blocked
Thread blocked
Thread blocked
Thread blocked
Thread blocked
Wake up all waiting threads...
Wait for threads and cleanup
Main completed
#endif
