﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
  *--------------------------------------------------------------------------------*/

#include "thread_test.h"
/* The header above includes other headers this file needs:
     #include <stdio.h>
*/
#include <pthread.h>
#include <errno.h>
#include "ntd-tests/ntd-tests.h"

int use_barrier;
pthread_barrier_t barrier;
static int test_num;

void test_barrier_EINVAL()
{
  int ret_val = 0;

  /* Passing in '0' for 3rd parameter should return EINVAL.
     Expecting function to fail right away, so no need to pass in valid
     pthread_barrier_t value */
  ret_val = pthread_barrier_init(NULL, NULL, 0);

  TESTCASE_MESSAGE(ret_val == EINVAL,
      "Expected pthread_barrier_init() to return EINVAL (%d). Got %d\n",
      EINVAL, ret_val);
}

void *thread_func(void *arg)
{
  int ret_val, saved_errno;

  TESTCASE_MESSAGE(test_num == 0,
      "test_num = %d. Expected it to remain 0 until after barrier_wait.\n", test_num);

  errno = 0;
  ret_val = pthread_barrier_wait(&barrier);
  saved_errno = errno;
  TESTCASE_MESSAGE(ret_val == 0 || ret_val == PTHREAD_BARRIER_SERIAL_THREAD,
      "pthread_barrier_wait() returned %d, expected 0 or PTHREAD_BARRIER_SERIAL_THREAD (%d)",
      ret_val, PTHREAD_BARRIER_SERIAL_THREAD);
  TESTCASE_MESSAGE(saved_errno == 0, "pthread_barrier_wait() triggered errno: %d ('%s')",
      saved_errno, strerror(saved_errno));

  ++test_num;
  return NULL;
}

void test_barrier_init_and_destroy()
{
  int i;
  const int num_threads = 3;
  int ret_val, saved_errno;
  pthread_t tids[num_threads];
  test_num = 0;


  errno = 0;
  ret_val = pthread_barrier_init(&barrier, NULL, num_threads);
  saved_errno = errno;
  TESTCASE_MESSAGE(ret_val == 0, "pthread_attr_init() returned %d, expected 0", ret_val);
  TESTCASE_MESSAGE(saved_errno == 0, "pthread_attr_init() triggered errno: %d ('%s')",
      saved_errno, strerror(saved_errno));

  for (i = 0; i < num_threads; i++)
  {
    errno = 0;
    ret_val = pthread_create(&tids[i], NULL, thread_func, NULL);
    saved_errno = errno;
    TESTCASE_MESSAGE(ret_val == 0, "pthread_create() returned %d, expected 0", ret_val);
    TESTCASE_MESSAGE(saved_errno == 0, "pthread_create() triggered errno: %d ('%s')",
        saved_errno, strerror(saved_errno));
  }

  for (i = 0; i < num_threads; i++)
  {
    errno = 0;
    ret_val = pthread_join(tids[i], NULL);
    saved_errno = errno;
    TESTCASE_MESSAGE(ret_val == 0, "pthread_join() returned %d, expected 0", ret_val);
    TESTCASE_MESSAGE(saved_errno == 0, "pthread_join() triggered errno: %d ('%s')",
        saved_errno, strerror(saved_errno));
  }

  errno = 0;
  ret_val = pthread_barrier_destroy(&barrier);
  saved_errno = errno;
  TESTCASE_MESSAGE(ret_val == 0, "pthread_barrier_destroy() returned %d, expected 0", ret_val);
  TESTCASE_MESSAGE(saved_errno == 0, "pthread_barrier_destroy() triggered errno: %d ('%s')",
      saved_errno, strerror(saved_errno));
}

void test_pthread_barrier(void)
{
  NTD_TEST_GROUP_START("pthread_barrier", 3);

  test_barrier_EINVAL();
  test_barrier_init_and_destroy();

  NTD_TEST_GROUP_END("pthread_barrier", 3);
}
