﻿/* $Id$ */

/* fprintf( FILE *, const char *, ... )

   This file is part of the Public Dotest_fprintf C Library (PDCLib).
   Permission is granted to use, modify, and / or redistribute at will.
*/

#include "ntd-test-libc.h"
#include <stdio.h>
#include <unistd.h>


#include <stdint.h>
#include <stddef.h>
#define NTD_FILEID "ntd_stdio_fprintf.c"
#define NTD_FILEIO

#include "ntd_stdio_tests.h"

#if __NX__
static const char *tempfilename = "host:/ntd-test-fprintf.txt";
#else
static const char *tempfilename = "ntd-test-fprintf.txt";
#endif

#define testprintf( stream, ... ) fprintf( stream, __VA_ARGS__ )

int ntd_stdio_fprintf( void )
{
    FILE * target;
    if (!access(tempfilename, F_OK)) {
    	TESTCASE( remove( tempfilename ) == 0 );
    }

    TESTCASE( ( target = fopen( tempfilename, "wb+" ) ) != NULL );
    // TESTCASE( ( target = tmpfile() ) != NULL );
#include "ntd_printf_testcases.h"
    TESTCASE( fclose( target ) == 0 );

    return TEST_RESULTS;
}


