﻿/* modified from glibc test case */
#include "ntd-test-libc.h"
#include <dirent.h>
#include <errno.h>
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <sys/stat.h>
#include <sys/types.h>


#if __NX__
#define tempdirname "host:/bug-readdir-1"
#else
#define tempdirname "bug-readdir-1"
#endif

static char message[256];

void ntd_dirent_bug_readdir1(void)
{
  DIR *dirp;
  struct dirent* ent;

  mkdir(tempdirname, 0777);   /* don't care if mkdir fails */

  /* open a dir stream */
  errno = 0;
  dirp = opendir (tempdirname);
  TESTCASE(dirp != NULL);
  if (dirp != NULL) {
    /* close the directory file descriptor, making it invalid */
    TESTCASE(close(dirfd(dirp)) == 0);
    errno = 0;
    ent = readdir (dirp);

    snprintf(message, sizeof(message), "ent == %p, errno = %d", ent, errno);

    TESTCASE_MESSAGE(ent == NULL && errno != 0, message);
    return;
  }

  if (errno == ENOENT) {
    TESTCASE_MESSAGE(errno != ENOENT, "directory does not exist: " tempdirname);
  } else {
    TESTCASE_FAILURE();
    perror ("opendir");
  }
}
