﻿#include "ntd_extended_test.h"
#include <stdlib.h> /* atexit(), malloc() */

/* Static global int to be incremented in each function to check if each
   function is being called */
static int static_int;

/* To check at the end if 'static_int' was added up properly */
static int total_funcs_called;

/* Makes sure static_int is being incremented properly */
void Update_static_int(int func_num)
{
  ++static_int;
  TESTCASE_MESSAGE(static_int == func_num, "func%d(): Unexpected value for 'static_int'. Got %d, wanted %d", func_num, static_int, func_num);
}


void func1(void)
{
  Update_static_int(1);
}

void func2(void)
{
  Update_static_int(2);
}

void func3(void)
{
  Update_static_int(3);

  /* Attempt to allocate and free some memory after the program has exited */
  char *buf;
  buf = malloc(20);
  if (is_ptr_null(buf)) return;
  buf[0] = 'x';
  buf[18] = 'y';
  buf[19] = 'z';
  free(buf);
}


/* These two functions check if atexit() can be called from a function
   that was already called using atexit() */
/*!!! ---> Commenting out this test of using nested atexit() calls since it
           doesn't work on other systems. It will remain commented out rather
           than deleted in case it's discovered that the C Standard states this
           feature must be supported
  !!! ---> If nested atexit() calls gets added in, then remember to change
           main() in this file (make it *not* call func5()) */
/*void func5(void)
{
  Update_static_int(5);
}
void func4(void)
{
  TESTCASE(atexit(func5));
  Update_static_int(4);
}*/
void func4(void)  { Update_static_int(4);  }
void func5(void)  { Update_static_int(5);  }


void func6(void)  { Update_static_int(6);  }
void func7(void)  { Update_static_int(7);  }
void func8(void)  { Update_static_int(8);  }
void func9(void)  { Update_static_int(9);  }
void func10(void) { Update_static_int(10); }
void func11(void) { Update_static_int(11); }
void func12(void) { Update_static_int(12); }
void func13(void) { Update_static_int(13); }
void func14(void) { Update_static_int(14); }
void func15(void) { Update_static_int(15); }
void func16(void) { Update_static_int(16); }
void func17(void) { Update_static_int(17); }
void func18(void) { Update_static_int(18); }
void func19(void) { Update_static_int(19); }
void func20(void) { Update_static_int(20); }
void func21(void) { Update_static_int(21); }
void func22(void) { Update_static_int(22); }
void func23(void) { Update_static_int(23); }
void func24(void) { Update_static_int(24); }
void func25(void) { Update_static_int(25); }
void func26(void) { Update_static_int(26); }
void func27(void) { Update_static_int(27); }
void func28(void) { Update_static_int(28); }
void func29(void) { Update_static_int(29); }

/* Test calling the same function twice */
void func30(void)
{
  if (static_int == 29)
    Update_static_int(30);
  else if (static_int == 30)
    Update_static_int(31);
  else
    TESTCASE_MESSAGE(static_int == 29 || static_int == 30,
        "func30(): 'static_int' has unexpected value. Got %d, "
            "wanted either 30 or 31\n", static_int);
}

void func32()
{
  int static_int_should_be = total_funcs_called;

  Update_static_int(32);

  TESTCASE_MESSAGE(static_int == static_int_should_be,
    "func32(): Totaled value of 'static_int' is unexpected: %d (wanted %d)\n",
            static_int, static_int_should_be);
}


int ntd_extended_atexit(void)
{
    static_int = 0;
    NTD_TEST_GROUP_START("atexit", 2);

  /* Call the functions in reverse order since they are pushed to a
     stack, meaning the last one called using atexit() will be the first
     one invoked when the program exits normally */

  /* Call atexit() 32 times in total since the C standard states that
     atexit() should support the registration of at least 32 functions
     (ISO/IEC 9899:201x, N1570, April 12, 2011)
     www.open-std.org/jtc1/sc22/wg14/www/docs/n1256.pdf */

    /* Test creating a separate function pointer and passing that into atexit() */
    void (* func_ptr)(void) = func32;
    TESTCASE(atexit(func_ptr)); ++total_funcs_called;

    /* Test calling the same function twice */
    TESTCASE(atexit(func30)); ++total_funcs_called;
    TESTCASE(atexit(func30)); ++total_funcs_called;

    TESTCASE(atexit(func29)); ++total_funcs_called;
    TESTCASE(atexit(func28)); ++total_funcs_called;
    TESTCASE(atexit(func27)); ++total_funcs_called;
    TESTCASE(atexit(func26)); ++total_funcs_called;
    TESTCASE(atexit(func25)); ++total_funcs_called;
    TESTCASE(atexit(func24)); ++total_funcs_called;
    TESTCASE(atexit(func23)); ++total_funcs_called;
    TESTCASE(atexit(func22)); ++total_funcs_called;
    TESTCASE(atexit(func21)); ++total_funcs_called;
    TESTCASE(atexit(func20)); ++total_funcs_called;
    TESTCASE(atexit(func19)); ++total_funcs_called;
    TESTCASE(atexit(func18)); ++total_funcs_called;
    TESTCASE(atexit(func17)); ++total_funcs_called;
    TESTCASE(atexit(func16)); ++total_funcs_called;
    TESTCASE(atexit(func15)); ++total_funcs_called;
    TESTCASE(atexit(func14)); ++total_funcs_called;
    TESTCASE(atexit(func13)); ++total_funcs_called;
    TESTCASE(atexit(func12)); ++total_funcs_called;
    TESTCASE(atexit(func11)); ++total_funcs_called;
    TESTCASE(atexit(func10)); ++total_funcs_called;
    TESTCASE(atexit(func9));  ++total_funcs_called;
    TESTCASE(atexit(func8));  ++total_funcs_called;
    TESTCASE(atexit(func7));  ++total_funcs_called;
    TESTCASE(atexit(func6));  ++total_funcs_called;
    TESTCASE(atexit(func5));  ++total_funcs_called;
    TESTCASE(atexit(func4));  ++total_funcs_called;
    TESTCASE(atexit(func3));  ++total_funcs_called;
    TESTCASE(atexit(func2));  ++total_funcs_called;
    TESTCASE(atexit(func1));  ++total_funcs_called;

    TESTCASE(static_int == 0,
        "static_int = %d, expected 0.\n", static_int);

    return NTD_TEST_GROUP_END("atexit", 2);
}
