﻿/*---------------------------------------------------------------------------*
  Copyright (C) 2016 Nintendo Co., Ltd.  All rights reserved.

  These coded instructions, statements, and computer programs contain
  proprietary information of Nintendo of America Inc. and/or Nintendo
  Company Ltd., and are protected by Federal copyright law.  They may
  not be disclosed to third parties or copied or duplicated in any form,
  in whole or in part, without the prior written consent of Nintendo.
 *---------------------------------------------------------------------------*/

#include "jira-regression-tests.h"
#include "ntd-test-libc.h"
#include <stdlib.h> //malloc
#include <stdio.h>
#include <stdio.h>
#include <wchar.h>

void rynda_576()
{
    NTD_TEST_GROUP_START("RYNDA-576", 1);

    wchar_t Buf1024;
    const wchar_t* long_string = L"XXXX Long test: Long test: Long test: Long test: Long test: Long test: Long test: Long test: Long test: Long test: Long test: Long test: Long test: Long test: Long test: Long test: Long test: Long test: Long test: Long test: Long test: Long test: Long test: Long test: Long test: Long test: Long test: Long test: Long test: Long test: woo: 0\n";
    size_t long_str_len = wcslen(long_string);
    int res;

    wchar_t* Buf = (wchar_t*)malloc(1024 * sizeof(wchar_t));
    TESTCASE_MESSAGE(Buf != 0, "malloc() failed - returned null pointer");
    if (!Buf) return;

    res = swprintf(Buf, 1024, long_string);
    TESTCASE_MESSAGE(res == long_str_len, "Expected swprintf() to return %d. Got %d", long_str_len, res);

    res = wcscmp(long_string, Buf);
    TESTCASE_MESSAGE(res == 0, "Strings aren't equal:\nExpected:\n\"%ls\"\nGot:\n\"%ls\"\n", long_string, Buf);

    free(Buf);

    NTD_TEST_GROUP_END("RYNDA-576", 1);
}
