#!/bin/bash

#-------------------------------------------------------------------------------
#  This runs the script that generates the "!.nact--external", then creates a
#  "LibcTest" folder in "SDK/Samples/Sources/Applications" and copies
#  "!.nact--external" to it, then edits "Samples/Sources/Applications/!.nact"
#  to add "build LibcTest" if needed.
#
#  This script assumes that the 'SIGLO_ROOT' variable is set. It's the path to
#  the SDK root directory, which is where the "NintendoSdkRootMark" file is.
#-------------------------------------------------------------------------------

# Make sure the output directories exist
if [ -z "$NINTENDO_SDK_ROOT" ]
then
    echo " -- ERROR -- Need to set NINTENDO_SDK_ROOT to the root of your SDK directory"
    exit 1
elif [ ! -d "$NINTENDO_SDK_ROOT" ]
then
    echo " -- ERROR -- 'NINTENDO_SDK_ROOT' is not set correctly. Directory doesn't exist: "${NINTENDO_SDK_ROOT}
    exit 1
fi
output_dir_tests=${NINTENDO_SDK_ROOT}/Tests/Sources/Tests/LibcTests/LibcTest
if [ ! -d "$output_dir_tests" ]
then
    echo "-- ERROR -- Expected output directory in Tests doesn't exist: "${output_dir_tests}
    exit 1
fi
output_dir_externals=${NINTENDO_SDK_ROOT}/Externals/Tests/LibcTest
if [ ! -d "$output_dir_externals" ]
then
    echo "-- ERROR -- Expected output directory in Externals doesn't exist: "${output_dir_externals}
    exit 1
fi

# Generate the nact file to be copied to the Tests folder
bash "./generate-nact-for-SDK-Tests.sh"

nact_file_name="!.nact"
nact_copy_file_name="!.nact--copy-to-tests"

# Overwrite !.nact file in SDK Tests folder
mv ${nact_copy_file_name} ${output_dir_tests}/${nact_file_name}

# Create backup in case something goes wrong
mv ${output_dir_externals} ${output_dir_externals}"--backup"

saved_pwd=${PWD}
cd ..
cp -R "./LibcTest" ${output_dir_externals}
cd ${saved_pwd}

echo -e "\nDone! LibcTest sources copied to:"
echo "  \""${output_dir_externals}"\""

echo -e "\nAnd LibcTest !.nact updated in:"
echo "  \""${output_dir_tests}"\""
