﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>

#include <nnt/gtest/detail/gtest-heap.h>
#include <nnt/gtest/detail/gtest-utility.h>

namespace nnt { namespace testing { namespace detail {

template<
    typename T0 = void, typename T1 = void, typename T2 = void,
    typename T3 = void, typename T4 = void, typename T5 = void,
    typename T6 = void, typename T7 = void, typename T8 = void,
    typename T9 = void>
class Tuple;

#define NNT_TESTING_DETAIL_TUPLE0(T) \
    Tuple<>
#define NNT_TESTING_DETAIL_TUPLE1(T) \
    Tuple<T##0, void, void, void, void, void, void, void, void, void>
#define NNT_TESTING_DETAIL_TUPLE2(T) \
    Tuple<T##0, T##1, void, void, void, void, void, void, void, void>
#define NNT_TESTING_DETAIL_TUPLE3(T) \
    Tuple<T##0, T##1, T##2, void, void, void, void, void, void, void>
#define NNT_TESTING_DETAIL_TUPLE4(T) \
    Tuple<T##0, T##1, T##2, T##3, void, void, void, void, void, void>
#define NNT_TESTING_DETAIL_TUPLE5(T) \
    Tuple<T##0, T##1, T##2, T##3, T##4, void, void, void, void, void>
#define NNT_TESTING_DETAIL_TUPLE6(T) \
    Tuple<T##0, T##1, T##2, T##3, T##4, T##5, void, void, void, void>
#define NNT_TESTING_DETAIL_TUPLE7(T) \
    Tuple<T##0, T##1, T##2, T##3, T##4, T##5, T##6, void, void, void>
#define NNT_TESTING_DETAIL_TUPLE8(T) \
    Tuple<T##0, T##1, T##2, T##3, T##4, T##5, T##6, T##7, void, void>
#define NNT_TESTING_DETAIL_TUPLE9(T) \
    Tuple<T##0, T##1, T##2, T##3, T##4, T##5, T##6, T##7, T##8, void>
#define NNT_TESTING_DETAIL_TUPLE10(T) \
    Tuple<T##0, T##1, T##2, T##3, T##4, T##5, T##6, T##7, T##8, T##9>

#define NNT_TESTING_DETAIL_TYPENAMES0(T)
#define NNT_TESTING_DETAIL_TYPENAMES1(T) \
    typename T##0
#define NNT_TESTING_DETAIL_TYPENAMES2(T) \
    typename T##0, typename T##1
#define NNT_TESTING_DETAIL_TYPENAMES3(T) \
    typename T##0, typename T##1, typename T##2
#define NNT_TESTING_DETAIL_TYPENAMES4(T) \
    typename T##0, typename T##1, typename T##2, typename T##3
#define NNT_TESTING_DETAIL_TYPENAMES5(T) \
    typename T##0, typename T##1, typename T##2, typename T##3, typename T##4
#define NNT_TESTING_DETAIL_TYPENAMES6(T) \
    typename T##0, typename T##1, typename T##2, typename T##3, typename T##4, \
    typename T##5
#define NNT_TESTING_DETAIL_TYPENAMES7(T) \
    typename T##0, typename T##1, typename T##2, typename T##3, typename T##4, \
    typename T##5, typename T##6
#define NNT_TESTING_DETAIL_TYPENAMES8(T) \
    typename T##0, typename T##1, typename T##2, typename T##3, typename T##4, \
    typename T##5, typename T##6, typename T##7
#define NNT_TESTING_DETAIL_TYPENAMES9(T) \
    typename T##0, typename T##1, typename T##2, typename T##3, typename T##4, \
    typename T##5, typename T##6, typename T##7, typename T##8
#define NNT_TESTING_DETAIL_TYPENAMES10(T) \
    typename T##0, typename T##1, typename T##2, typename T##3, typename T##4, \
    typename T##5, typename T##6, typename T##7, typename T##8, typename T##9

template<typename T>
struct ByRef final
{
    typedef const T& Type;  // NOLINT
};

template<typename T>
struct ByRef<T&> final
{
    typedef T& Type;        // NOLINT
};

template <typename T>
struct AddRef final
{
    typedef T& Type;        // NOLINT
};

template <typename T>
struct AddRef<T&>
{
    typedef T& Type;        // NOLINT
};

template <int N> class GetImpl;

template <bool IsValid, int N, class Tuple>
struct TupleElementImpl;

template <NNT_TESTING_DETAIL_TYPENAMES10(T)>
struct TupleElementImpl<true, 0, NNT_TESTING_DETAIL_TUPLE10(T)> final
{
    typedef T0 Type;
};

template <NNT_TESTING_DETAIL_TYPENAMES10(T)>
struct TupleElementImpl<true, 1, NNT_TESTING_DETAIL_TUPLE10(T)> final
{
    typedef T1 Type;
};

template <NNT_TESTING_DETAIL_TYPENAMES10(T)>
struct TupleElementImpl<true, 2, NNT_TESTING_DETAIL_TUPLE10(T)> final
{
    typedef T2 Type;
};

template <NNT_TESTING_DETAIL_TYPENAMES10(T)>
struct TupleElementImpl<true, 3, NNT_TESTING_DETAIL_TUPLE10(T)> final
{
    typedef T3 Type;
};

template <NNT_TESTING_DETAIL_TYPENAMES10(T)>
struct TupleElementImpl<true, 4, NNT_TESTING_DETAIL_TUPLE10(T)> final
{
    typedef T4 Type;
};

template <NNT_TESTING_DETAIL_TYPENAMES10(T)>
struct TupleElementImpl<true, 5, NNT_TESTING_DETAIL_TUPLE10(T)> final
{
    typedef T5 Type;
};

template <NNT_TESTING_DETAIL_TYPENAMES10(T)>
struct TupleElementImpl<true, 6, NNT_TESTING_DETAIL_TUPLE10(T)> final
{
    typedef T6 Type;
};

template <NNT_TESTING_DETAIL_TYPENAMES10(T)>
struct TupleElementImpl<true, 7, NNT_TESTING_DETAIL_TUPLE10(T)> final
{
    typedef T7 Type;
};

template <NNT_TESTING_DETAIL_TYPENAMES10(T)>
struct TupleElementImpl<true, 8, NNT_TESTING_DETAIL_TUPLE10(T)> final
{
    typedef T8 Type;
};

template <NNT_TESTING_DETAIL_TYPENAMES10(T)>
struct TupleElementImpl<true, 9, NNT_TESTING_DETAIL_TUPLE10(T)> final
{
    typedef T9 Type;
};

template <>
class Tuple<> final
{
public:
    NNT_TESTING_DETAIL_HEAP_IS_ALLOCATABLE();

public:
    Tuple() NN_NOEXCEPT
    {
    }

    Tuple(const Tuple& other) NN_NOEXCEPT
    {
        NN_UNUSED(other);
    }

    Tuple& operator=(const Tuple& other) NN_NOEXCEPT
    {
        NN_UNUSED(other);

        return *this;
    }
};

template <NNT_TESTING_DETAIL_TYPENAMES1(T)>
class NNT_TESTING_DETAIL_TUPLE1(T) final
{
public:
    NNT_TESTING_DETAIL_HEAP_IS_ALLOCATABLE();

public:
    Tuple() NN_NOEXCEPT
        : m_F0()
    {
    }

    explicit Tuple(typename ByRef<T0>::Type f0) NN_NOEXCEPT
        : m_F0(f0)
    {
    }

    Tuple(const Tuple& other) NN_NOEXCEPT
        : m_F0(other.m_F0)
    {
    }

    template <NNT_TESTING_DETAIL_TYPENAMES1(U)>
    Tuple(const NNT_TESTING_DETAIL_TUPLE1(U)& other) NN_NOEXCEPT
        : m_F0(other.m_F0)
    {
    }

    Tuple& operator=(const Tuple& other) NN_NOEXCEPT
    {
        return this->CopyFrom(other);
    }

    template <NNT_TESTING_DETAIL_TYPENAMES1(U)>
    Tuple& operator=(const NNT_TESTING_DETAIL_TUPLE1(U)& other) NN_NOEXCEPT
    {
        return this->CopyFrom(other);
    }

    template <int N> friend class GetImpl;

    template <NNT_TESTING_DETAIL_TYPENAMES10(U)> friend class Tuple;

private:
    template <NNT_TESTING_DETAIL_TYPENAMES1(U)>
    Tuple& CopyFrom(const NNT_TESTING_DETAIL_TUPLE1(U)& other) NN_NOEXCEPT
    {
        m_F0 = other.m_F0;

        return *this;
    }

    T0 m_F0;
};

template <NNT_TESTING_DETAIL_TYPENAMES2(T)>
class NNT_TESTING_DETAIL_TUPLE2(T) final
{
public:
    NNT_TESTING_DETAIL_HEAP_IS_ALLOCATABLE();

public:
    Tuple() NN_NOEXCEPT
        : m_F0()
        , m_F1()
    {
    }

    Tuple(typename ByRef<T0>::Type f0,
          typename ByRef<T1>::Type f1) NN_NOEXCEPT
        : m_F0(f0)
        , m_F1(f1)
    {
    }

    Tuple(const Tuple& other) NN_NOEXCEPT
        : m_F0(other.m_F0)
        , m_F1(other.m_F1)
    {
    }

    template <NNT_TESTING_DETAIL_TYPENAMES2(U)>
    Tuple(const NNT_TESTING_DETAIL_TUPLE2(U)& other) NN_NOEXCEPT
        : m_F0(other.m_F0)
        , m_F1(other.m_F1)
    {
    }

    template <typename U0, typename U1>
    Tuple(const Pair<U0, U1>& pair)
        : m_F0(pair.first)
        , m_F1(pair.second)
    {
    }

    Tuple& operator=(const Tuple& other) NN_NOEXCEPT
    {
        return this->CopyFrom(other);
    }

    template <NNT_TESTING_DETAIL_TYPENAMES2(U)>
    Tuple& operator=(const NNT_TESTING_DETAIL_TUPLE2(U)& other) NN_NOEXCEPT
    {
        return this->CopyFrom(other);
    }

    template <typename U0, typename U1>
    Tuple& operator=(const Pair<U0, U1>& pair)
    {
        m_F0 = pair.first;
        m_F1 = pair.second;

        return *this;
    }

    template <int N> friend class GetImpl;

    template <NNT_TESTING_DETAIL_TYPENAMES10(U)> friend class Tuple;

private:
    template <NNT_TESTING_DETAIL_TYPENAMES2(U)>
    Tuple& CopyFrom(const NNT_TESTING_DETAIL_TUPLE2(U)& other) NN_NOEXCEPT
    {
        m_F0 = other.m_F0;
        m_F1 = other.m_F1;

        return *this;
    }

    T0 m_F0;
    T1 m_F1;
};

template <NNT_TESTING_DETAIL_TYPENAMES3(T)>
class NNT_TESTING_DETAIL_TUPLE3(T) final
{
public:
    NNT_TESTING_DETAIL_HEAP_IS_ALLOCATABLE();

public:
    Tuple() NN_NOEXCEPT
        : m_F0()
        , m_F1()
        , m_F2()
    {
    }

    explicit Tuple(
        typename ByRef<T0>::Type f0,
        typename ByRef<T1>::Type f1,
        typename ByRef<T2>::Type f2) NN_NOEXCEPT
        : m_F0(f0)
        , m_F1(f1)
        , m_F2(f2)
    {
    }

    Tuple(const Tuple& other) NN_NOEXCEPT
        : m_F0(other.m_F0)
        , m_F1(other.m_F1)
        , m_F2(other.m_F2)
    {
    }

    template <NNT_TESTING_DETAIL_TYPENAMES3(U)>
    Tuple(const NNT_TESTING_DETAIL_TUPLE3(U)& other) NN_NOEXCEPT
        : m_F0(other.m_F0)
        , m_F1(other.m_F1)
        , m_F2(other.m_F2)
    {
    }

    Tuple& operator=(const Tuple& other) NN_NOEXCEPT
    {
        return this->CopyFrom(other);
    }

    template <NNT_TESTING_DETAIL_TYPENAMES3(U)>
    Tuple& operator=(const NNT_TESTING_DETAIL_TUPLE3(U)& other) NN_NOEXCEPT
    {
        return this->CopyFrom(other);
    }

    template <int N> friend class GetImpl;

    template <NNT_TESTING_DETAIL_TYPENAMES10(U)> friend class Tuple;

private:
    template <NNT_TESTING_DETAIL_TYPENAMES3(U)>
    Tuple& CopyFrom(const NNT_TESTING_DETAIL_TUPLE3(U)& other) NN_NOEXCEPT
    {
        m_F0 = other.m_F0;
        m_F1 = other.m_F1;
        m_F2 = other.m_F2;

        return *this;
    }

    T0 m_F0;
    T1 m_F1;
    T2 m_F2;
};

template <NNT_TESTING_DETAIL_TYPENAMES4(T)>
class NNT_TESTING_DETAIL_TUPLE4(T) final
{
public:
    NNT_TESTING_DETAIL_HEAP_IS_ALLOCATABLE();

public:
    Tuple() NN_NOEXCEPT
        : m_F0()
        , m_F1()
        , m_F2()
        , m_F3()
    {
    }

    explicit Tuple(
        typename ByRef<T0>::Type f0,
        typename ByRef<T1>::Type f1,
        typename ByRef<T2>::Type f2,
        typename ByRef<T3>::Type f3) NN_NOEXCEPT
        : m_F0(f0)
        , m_F1(f1)
        , m_F2(f2)
        , m_F3(f3)
    {
    }

    Tuple(const Tuple& other) NN_NOEXCEPT
        : m_F0(other.m_F0)
        , m_F1(other.m_F1)
        , m_F2(other.m_F2)
        , m_F3(other.m_F3)
    {
    }

    template <NNT_TESTING_DETAIL_TYPENAMES4(U)>
    Tuple(const NNT_TESTING_DETAIL_TUPLE4(U)& other) NN_NOEXCEPT
        : m_F0(other.m_F0)
        , m_F1(other.m_F1)
        , m_F2(other.m_F2)
        , m_F3(other.m_F3)
    {
    }

    Tuple& operator=(const Tuple& other) NN_NOEXCEPT
    {
        return this->CopyFrom(other);
    }

    template <NNT_TESTING_DETAIL_TYPENAMES4(U)>
    Tuple& operator=(const NNT_TESTING_DETAIL_TUPLE4(U)& other) NN_NOEXCEPT
    {
        return this->CopyFrom(other);
    }

    template <int N> friend class GetImpl;

    template <NNT_TESTING_DETAIL_TYPENAMES10(U)> friend class Tuple;

private:
    template <NNT_TESTING_DETAIL_TYPENAMES4(U)>
    Tuple& CopyFrom(const NNT_TESTING_DETAIL_TUPLE4(U)& other) NN_NOEXCEPT
    {
        m_F0 = other.m_F0;
        m_F1 = other.m_F1;
        m_F2 = other.m_F2;
        m_F3 = other.m_F3;

        return *this;
    }

    T0 m_F0;
    T1 m_F1;
    T2 m_F2;
    T3 m_F3;
};

template <NNT_TESTING_DETAIL_TYPENAMES5(T)>
class NNT_TESTING_DETAIL_TUPLE5(T) final
{
public:
    NNT_TESTING_DETAIL_HEAP_IS_ALLOCATABLE();

public:
    Tuple() NN_NOEXCEPT
        : m_F0()
        , m_F1()
        , m_F2()
        , m_F3()
        , m_F4()
    {
    }

    explicit Tuple(
        typename ByRef<T0>::Type f0,
        typename ByRef<T1>::Type f1,
        typename ByRef<T2>::Type f2,
        typename ByRef<T3>::Type f3,
        typename ByRef<T4>::Type f4) NN_NOEXCEPT
        : m_F0(f0)
        , m_F1(f1)
        , m_F2(f2)
        , m_F3(f3)
        , m_F4(f4)
    {
    }

    Tuple(const Tuple& other) NN_NOEXCEPT
        : m_F0(other.m_F0)
        , m_F1(other.m_F1)
        , m_F2(other.m_F2)
        , m_F3(other.m_F3)
        , m_F4(other.m_F4)
    {
    }

    template <NNT_TESTING_DETAIL_TYPENAMES5(U)>
    Tuple(const NNT_TESTING_DETAIL_TUPLE5(U)& other) NN_NOEXCEPT
        : m_F0(other.m_F0)
        , m_F1(other.m_F1)
        , m_F2(other.m_F2)
        , m_F3(other.m_F3)
        , m_F4(other.m_F4)
    {
    }

    Tuple& operator=(const Tuple& other) NN_NOEXCEPT
    {
        return this->CopyFrom(other);
    }

    template <NNT_TESTING_DETAIL_TYPENAMES5(U)>
    Tuple& operator=(const NNT_TESTING_DETAIL_TUPLE5(U)& other) NN_NOEXCEPT
    {
        return this->CopyFrom(other);
    }

    template <int N> friend class GetImpl;

    template <NNT_TESTING_DETAIL_TYPENAMES10(U)> friend class Tuple;

private:
    template <NNT_TESTING_DETAIL_TYPENAMES5(U)>
    Tuple& CopyFrom(const NNT_TESTING_DETAIL_TUPLE5(U)& other) NN_NOEXCEPT
    {
        m_F0 = other.m_F0;
        m_F1 = other.m_F1;
        m_F2 = other.m_F2;
        m_F3 = other.m_F3;
        m_F4 = other.m_F4;

        return *this;
    }

    T0 m_F0;
    T1 m_F1;
    T2 m_F2;
    T3 m_F3;
    T4 m_F4;
};

template <NNT_TESTING_DETAIL_TYPENAMES6(T)>
class NNT_TESTING_DETAIL_TUPLE6(T) final
{
public:
    NNT_TESTING_DETAIL_HEAP_IS_ALLOCATABLE();

public:
    Tuple() NN_NOEXCEPT
        : m_F0()
        , m_F1()
        , m_F2()
        , m_F3()
        , m_F4()
        , m_F5()
    {
    }

    explicit Tuple(
        typename ByRef<T0>::Type f0,
        typename ByRef<T1>::Type f1,
        typename ByRef<T2>::Type f2,
        typename ByRef<T3>::Type f3,
        typename ByRef<T4>::Type f4,
        typename ByRef<T5>::Type f5) NN_NOEXCEPT
        : m_F0(f0)
        , m_F1(f1)
        , m_F2(f2)
        , m_F3(f3)
        , m_F4(f4)
        , m_F5(f5)
    {
    }

    Tuple(const Tuple& other) NN_NOEXCEPT
        : m_F0(other.m_F0)
        , m_F1(other.m_F1)
        , m_F2(other.m_F2)
        , m_F3(other.m_F3)
        , m_F4(other.m_F4)
        , m_F5(other.m_F5)
    {
    }

    template <NNT_TESTING_DETAIL_TYPENAMES6(U)>
    Tuple(const NNT_TESTING_DETAIL_TUPLE6(U)& other) NN_NOEXCEPT
        : m_F0(other.m_F0)
        , m_F1(other.m_F1)
        , m_F2(other.m_F2)
        , m_F3(other.m_F3)
        , m_F4(other.m_F4)
        , m_F5(other.m_F5)
    {
    }

    Tuple& operator=(const Tuple& other) NN_NOEXCEPT
    {
        return this->CopyFrom(other);
    }

    template <NNT_TESTING_DETAIL_TYPENAMES6(U)>
    Tuple& operator=(const NNT_TESTING_DETAIL_TUPLE6(U)& other) NN_NOEXCEPT
    {
        return this->CopyFrom(other);
    }

    template <int N> friend class GetImpl;

    template <NNT_TESTING_DETAIL_TYPENAMES10(U)> friend class Tuple;

private:
    template <NNT_TESTING_DETAIL_TYPENAMES6(U)>
    Tuple& CopyFrom(const NNT_TESTING_DETAIL_TUPLE6(U)& other) NN_NOEXCEPT
    {
        m_F0 = other.m_F0;
        m_F1 = other.m_F1;
        m_F2 = other.m_F2;
        m_F3 = other.m_F3;
        m_F4 = other.m_F4;
        m_F5 = other.m_F5;

        return *this;
    }

    T0 m_F0;
    T1 m_F1;
    T2 m_F2;
    T3 m_F3;
    T4 m_F4;
    T5 m_F5;
};

template <NNT_TESTING_DETAIL_TYPENAMES7(T)>
class NNT_TESTING_DETAIL_TUPLE7(T) final
{
public:
    NNT_TESTING_DETAIL_HEAP_IS_ALLOCATABLE();

public:
    Tuple() NN_NOEXCEPT
        : m_F0()
        , m_F1()
        , m_F2()
        , m_F3()
        , m_F4()
        , m_F5()
        , m_F6()
    {
    }

    explicit Tuple(
        typename ByRef<T0>::Type f0,
        typename ByRef<T1>::Type f1,
        typename ByRef<T2>::Type f2,
        typename ByRef<T3>::Type f3,
        typename ByRef<T4>::Type f4,
        typename ByRef<T5>::Type f5,
        typename ByRef<T6>::Type f6) NN_NOEXCEPT
        : m_F0(f0)
        , m_F1(f1)
        , m_F2(f2)
        , m_F3(f3)
        , m_F4(f4)
        , m_F5(f5)
        , m_F6(f6)
    {
    }

    Tuple(const Tuple& other) NN_NOEXCEPT
        : m_F0(other.m_F0)
        , m_F1(other.m_F1)
        , m_F2(other.m_F2)
        , m_F3(other.m_F3)
        , m_F4(other.m_F4)
        , m_F5(other.m_F5)
        , m_F6(other.m_F6)
    {
    }

    template <NNT_TESTING_DETAIL_TYPENAMES7(U)>
    Tuple(const NNT_TESTING_DETAIL_TUPLE7(U)& other) NN_NOEXCEPT
        : m_F0(other.m_F0)
        , m_F1(other.m_F1)
        , m_F2(other.m_F2)
        , m_F3(other.m_F3)
        , m_F4(other.m_F4)
        , m_F5(other.m_F5)
        , m_F6(other.m_F6)
    {
    }

    Tuple& operator=(const Tuple& other) NN_NOEXCEPT
    {
        return this->CopyFrom(other);
    }

    template <NNT_TESTING_DETAIL_TYPENAMES7(U)>
    Tuple& operator=(const NNT_TESTING_DETAIL_TUPLE7(U)& other) NN_NOEXCEPT
    {
        return this->CopyFrom(other);
    }

    template <int N> friend class GetImpl;

    template <NNT_TESTING_DETAIL_TYPENAMES10(U)> friend class Tuple;

private:
    template <NNT_TESTING_DETAIL_TYPENAMES7(U)>
    Tuple& CopyFrom(const NNT_TESTING_DETAIL_TUPLE7(U)& other) NN_NOEXCEPT
    {
        m_F0 = other.m_F0;
        m_F1 = other.m_F1;
        m_F2 = other.m_F2;
        m_F3 = other.m_F3;
        m_F4 = other.m_F4;
        m_F5 = other.m_F5;
        m_F6 = other.m_F6;

        return *this;
    }

    T0 m_F0;
    T1 m_F1;
    T2 m_F2;
    T3 m_F3;
    T4 m_F4;
    T5 m_F5;
    T6 m_F6;
};

template <NNT_TESTING_DETAIL_TYPENAMES8(T)>
class NNT_TESTING_DETAIL_TUPLE8(T) final
{
public:
    NNT_TESTING_DETAIL_HEAP_IS_ALLOCATABLE();

public:
    Tuple() NN_NOEXCEPT
        : m_F0()
        , m_F1()
        , m_F2()
        , m_F3()
        , m_F4()
        , m_F5()
        , m_F6()
        , m_F7()
    {
    }

    explicit Tuple(
        typename ByRef<T0>::Type f0,
        typename ByRef<T1>::Type f1,
        typename ByRef<T2>::Type f2,
        typename ByRef<T3>::Type f3,
        typename ByRef<T4>::Type f4,
        typename ByRef<T5>::Type f5,
        typename ByRef<T6>::Type f6,
        typename ByRef<T7>::Type f7) NN_NOEXCEPT
        : m_F0(f0)
        , m_F1(f1)
        , m_F2(f2)
        , m_F3(f3)
        , m_F4(f4)
        , m_F5(f5)
        , m_F6(f6)
        , m_F7(f7)
    {
    }

    Tuple(const Tuple& other) NN_NOEXCEPT
        : m_F0(other.m_F0)
        , m_F1(other.m_F1)
        , m_F2(other.m_F2)
        , m_F3(other.m_F3)
        , m_F4(other.m_F4)
        , m_F5(other.m_F5)
        , m_F6(other.m_F6)
        , m_F7(other.m_F7)
    {
    }

    template <NNT_TESTING_DETAIL_TYPENAMES8(U)>
    Tuple(const NNT_TESTING_DETAIL_TUPLE8(U)& other) NN_NOEXCEPT
        : m_F0(other.m_F0)
        , m_F1(other.m_F1)
        , m_F2(other.m_F2)
        , m_F3(other.m_F3)
        , m_F4(other.m_F4)
        , m_F5(other.m_F5)
        , m_F6(other.m_F6)
        , m_F7(other.m_F7)
    {
    }

    Tuple& operator=(const Tuple& other) NN_NOEXCEPT
    {
        return this->CopyFrom(other);
    }

    template <NNT_TESTING_DETAIL_TYPENAMES8(U)>
    Tuple& operator=(const NNT_TESTING_DETAIL_TUPLE8(U)& other) NN_NOEXCEPT
    {
        return this->CopyFrom(other);
    }

    template <int N> friend class GetImpl;

    template <NNT_TESTING_DETAIL_TYPENAMES10(U)> friend class Tuple;

private:
    template <NNT_TESTING_DETAIL_TYPENAMES8(U)>
    Tuple& CopyFrom(const NNT_TESTING_DETAIL_TUPLE8(U)& other) NN_NOEXCEPT
    {
        m_F0 = other.m_F0;
        m_F1 = other.m_F1;
        m_F2 = other.m_F2;
        m_F3 = other.m_F3;
        m_F4 = other.m_F4;
        m_F5 = other.m_F5;
        m_F6 = other.m_F6;
        m_F7 = other.m_F7;

        return *this;
    }

    T0 m_F0;
    T1 m_F1;
    T2 m_F2;
    T3 m_F3;
    T4 m_F4;
    T5 m_F5;
    T6 m_F6;
    T7 m_F7;
};

template <NNT_TESTING_DETAIL_TYPENAMES9(T)>
class NNT_TESTING_DETAIL_TUPLE9(T) final
{
public:
    NNT_TESTING_DETAIL_HEAP_IS_ALLOCATABLE();

public:
    Tuple() NN_NOEXCEPT
        : m_F0()
        , m_F1()
        , m_F2()
        , m_F3()
        , m_F4()
        , m_F5()
        , m_F6()
        , m_F7()
        , m_F8()
    {
    }

    explicit Tuple(
        typename ByRef<T0>::Type f0,
        typename ByRef<T1>::Type f1,
        typename ByRef<T2>::Type f2,
        typename ByRef<T3>::Type f3,
        typename ByRef<T4>::Type f4,
        typename ByRef<T5>::Type f5,
        typename ByRef<T6>::Type f6,
        typename ByRef<T7>::Type f7,
        typename ByRef<T8>::Type f8) NN_NOEXCEPT
        : m_F0(f0)
        , m_F1(f1)
        , m_F2(f2)
        , m_F3(f3)
        , m_F4(f4)
        , m_F5(f5)
        , m_F6(f6)
        , m_F7(f7)
        , m_F8(f8)
    {
    }

    Tuple(const Tuple& other) NN_NOEXCEPT
        : m_F0(other.m_F0)
        , m_F1(other.m_F1)
        , m_F2(other.m_F2)
        , m_F3(other.m_F3)
        , m_F4(other.m_F4)
        , m_F5(other.m_F5)
        , m_F6(other.m_F6)
        , m_F7(other.m_F7)
        , m_F8(other.m_F8)
    {
    }

    template <NNT_TESTING_DETAIL_TYPENAMES9(U)>
    Tuple(const NNT_TESTING_DETAIL_TUPLE9(U)& other) NN_NOEXCEPT
        : m_F0(other.m_F0)
        , m_F1(other.m_F1)
        , m_F2(other.m_F2)
        , m_F3(other.m_F3)
        , m_F4(other.m_F4)
        , m_F5(other.m_F5)
        , m_F6(other.m_F6)
        , m_F7(other.m_F7)
        , m_F8(other.m_F8)
    {
    }

    Tuple& operator=(const Tuple& other) NN_NOEXCEPT
    {
        return this->CopyFrom(other);
    }

    template <NNT_TESTING_DETAIL_TYPENAMES9(U)>
    Tuple& operator=(const NNT_TESTING_DETAIL_TUPLE9(U)& other) NN_NOEXCEPT
    {
        return this->CopyFrom(other);
    }

    template <int N> friend class GetImpl;

    template <NNT_TESTING_DETAIL_TYPENAMES10(U)> friend class Tuple;

private:
    template <NNT_TESTING_DETAIL_TYPENAMES9(U)>
    Tuple& CopyFrom(const NNT_TESTING_DETAIL_TUPLE9(U)& other) NN_NOEXCEPT
    {
        m_F0 = other.m_F0;
        m_F1 = other.m_F1;
        m_F2 = other.m_F2;
        m_F3 = other.m_F3;
        m_F4 = other.m_F4;
        m_F5 = other.m_F5;
        m_F6 = other.m_F6;
        m_F7 = other.m_F7;
        m_F8 = other.m_F8;

        return *this;
    }

    T0 m_F0;
    T1 m_F1;
    T2 m_F2;
    T3 m_F3;
    T4 m_F4;
    T5 m_F5;
    T6 m_F6;
    T7 m_F7;
    T8 m_F8;
};

template <NNT_TESTING_DETAIL_TYPENAMES10(T)>
class Tuple final
{
public:
    NNT_TESTING_DETAIL_HEAP_IS_ALLOCATABLE();

public:
    Tuple() NN_NOEXCEPT
        : m_F0()
        , m_F1()
        , m_F2()
        , m_F3()
        , m_F4()
        , m_F5()
        , m_F6()
        , m_F7()
        , m_F8()
        , m_F9()
    {
    }

    explicit Tuple(
        typename ByRef<T0>::Type f0,
        typename ByRef<T1>::Type f1,
        typename ByRef<T2>::Type f2,
        typename ByRef<T3>::Type f3,
        typename ByRef<T4>::Type f4,
        typename ByRef<T5>::Type f5,
        typename ByRef<T6>::Type f6,
        typename ByRef<T7>::Type f7,
        typename ByRef<T8>::Type f8,
        typename ByRef<T9>::Type f9) NN_NOEXCEPT
        : m_F0(f0)
        , m_F1(f1)
        , m_F2(f2)
        , m_F3(f3)
        , m_F4(f4)
        , m_F5(f5)
        , m_F6(f6)
        , m_F7(f7)
        , m_F8(f8)
        , m_F9(f9)
    {
    }

    Tuple(const Tuple& other) NN_NOEXCEPT
        : m_F0(other.m_F0)
        , m_F1(other.m_F1)
        , m_F2(other.m_F2)
        , m_F3(other.m_F3)
        , m_F4(other.m_F4)
        , m_F5(other.m_F5)
        , m_F6(other.m_F6)
        , m_F7(other.m_F7)
        , m_F8(other.m_F8)
        , m_F9(other.m_F9)
    {
    }

    template <NNT_TESTING_DETAIL_TYPENAMES10(U)>
    Tuple(const NNT_TESTING_DETAIL_TUPLE10(U)& other) NN_NOEXCEPT
        : m_F0(other.m_F0)
        , m_F1(other.m_F1)
        , m_F2(other.m_F2)
        , m_F3(other.m_F3)
        , m_F4(other.m_F4)
        , m_F5(other.m_F5)
        , m_F6(other.m_F6)
        , m_F7(other.m_F7)
        , m_F8(other.m_F8)
        , m_F9(other.m_F9)
    {
    }

    Tuple& operator=(const Tuple& other) NN_NOEXCEPT
    {
        return this->CopyFrom(other);
    }

    template <NNT_TESTING_DETAIL_TYPENAMES10(U)>
    Tuple& operator=(const NNT_TESTING_DETAIL_TUPLE10(U)& other) NN_NOEXCEPT
    {
        return this->CopyFrom(other);
    }

    template <int N> friend class GetImpl;

    template <NNT_TESTING_DETAIL_TYPENAMES10(U)> friend class Tuple;

private:
    template <NNT_TESTING_DETAIL_TYPENAMES10(U)>
    Tuple& CopyFrom(const NNT_TESTING_DETAIL_TUPLE10(U)& other) NN_NOEXCEPT
    {
        m_F0 = other.m_F0;
        m_F1 = other.m_F1;
        m_F2 = other.m_F2;
        m_F3 = other.m_F3;
        m_F4 = other.m_F4;
        m_F5 = other.m_F5;
        m_F6 = other.m_F6;
        m_F7 = other.m_F7;
        m_F8 = other.m_F8;
        m_F9 = other.m_F9;

        return *this;
    }

    T0 m_F0;
    T1 m_F1;
    T2 m_F2;
    T3 m_F3;
    T4 m_F4;
    T5 m_F5;
    T6 m_F6;
    T7 m_F7;
    T8 m_F8;
    T9 m_F9;
};

template <typename Tuple>
struct TupleSize;

template <NNT_TESTING_DETAIL_TYPENAMES0(T)>
struct TupleSize<NNT_TESTING_DETAIL_TUPLE0(T)> final
{
    static const int value = 0;
};

template <NNT_TESTING_DETAIL_TYPENAMES1(T)>
struct TupleSize<NNT_TESTING_DETAIL_TUPLE1(T)> final
{
    static const int value = 1;
};

template <NNT_TESTING_DETAIL_TYPENAMES2(T)>
struct TupleSize<NNT_TESTING_DETAIL_TUPLE2(T)> final
{
    static const int value = 2;
};

template <NNT_TESTING_DETAIL_TYPENAMES3(T)>
struct TupleSize<NNT_TESTING_DETAIL_TUPLE3(T)> final
{
    static const int value = 3;
};

template <NNT_TESTING_DETAIL_TYPENAMES4(T)>
struct TupleSize<NNT_TESTING_DETAIL_TUPLE4(T)> final
{
    static const int value = 4;
};

template <NNT_TESTING_DETAIL_TYPENAMES5(T)>
struct TupleSize<NNT_TESTING_DETAIL_TUPLE5(T)> final
{
    static const int value = 5;
};

template <NNT_TESTING_DETAIL_TYPENAMES6(T)>
struct TupleSize<NNT_TESTING_DETAIL_TUPLE6(T)> final
{
    static const int value = 6;
};

template <NNT_TESTING_DETAIL_TYPENAMES7(T)>
struct TupleSize<NNT_TESTING_DETAIL_TUPLE7(T)> final
{
    static const int value = 7;
};

template <NNT_TESTING_DETAIL_TYPENAMES8(T)>
struct TupleSize<NNT_TESTING_DETAIL_TUPLE8(T)> final
{
    static const int value = 8;
};

template <NNT_TESTING_DETAIL_TYPENAMES9(T)>
struct TupleSize<NNT_TESTING_DETAIL_TUPLE9(T)> final
{
    static const int value = 9;
};

template <NNT_TESTING_DETAIL_TYPENAMES10(T)>
struct TupleSize<NNT_TESTING_DETAIL_TUPLE10(T)> final
{
    static const int value = 10;
};

template <int N, class Tuple>
struct TupleElement
{
  typedef typename TupleElementImpl<
      N < (TupleSize<Tuple>::value), N, Tuple>::Type type;
};

template <>
class GetImpl<0> {
public:
    template <class Tuple>
    static typename AddRef<typename TupleElement<0, Tuple>::type>::Type
    GetField(Tuple& tuple) NN_NOEXCEPT
    {
        return tuple.m_F0;  // NOLINT
    }

    template <class Tuple>
    static typename ByRef<typename TupleElement<0, Tuple>::type>::Type
    GetConstField(const Tuple& tuple) NN_NOEXCEPT
    {
        return tuple.m_F0;
    }
};

template <>
class GetImpl<1> {
public:
    template <class Tuple>
    static typename AddRef<typename TupleElement<1, Tuple>::type>::Type
    GetField(Tuple& tuple) NN_NOEXCEPT
    {
        return tuple.m_F1;  // NOLINT
    }

    template <class Tuple>
    static typename ByRef<typename TupleElement<1, Tuple>::type>::Type
    GetConstField(const Tuple& tuple) NN_NOEXCEPT
    {
        return tuple.m_F1;
    }
};

template <>
class GetImpl<2> {
public:
    template <class Tuple>
    static typename AddRef<typename TupleElement<2, Tuple>::type>::Type
    GetField(Tuple& tuple) NN_NOEXCEPT
    {
        return tuple.m_F2;  // NOLINT
    }

    template <class Tuple>
    static typename ByRef<typename TupleElement<2, Tuple>::type>::Type
    GetConstField(const Tuple& tuple) NN_NOEXCEPT
    {
        return tuple.m_F2;
    }
};

template <>
class GetImpl<3> {
public:
    template <class Tuple>
    static typename AddRef<typename TupleElement<3, Tuple>::type>::Type
    GetField(Tuple& tuple) NN_NOEXCEPT
    {
        return tuple.m_F3;  // NOLINT
    }

    template <class Tuple>
    static typename ByRef<typename TupleElement<3, Tuple>::type>::Type
    GetConstField(const Tuple& tuple) NN_NOEXCEPT
    {
        return tuple.m_F3;
    }
};

template <>
class GetImpl<4> {
public:
    template <class Tuple>
    static typename AddRef<typename TupleElement<4, Tuple>::type>::Type
    GetField(Tuple& tuple) NN_NOEXCEPT
    {
        return tuple.m_F4;  // NOLINT
    }

    template <class Tuple>
    static typename ByRef<typename TupleElement<4, Tuple>::type>::Type
    GetConstField(const Tuple& tuple) NN_NOEXCEPT
    {
        return tuple.m_F4;
    }
};

template <>
class GetImpl<5> {
public:
    template <class Tuple>
    static typename AddRef<typename TupleElement<5, Tuple>::type>::Type
    GetField(Tuple& tuple) NN_NOEXCEPT
    {
        return tuple.m_F5;  // NOLINT
    }

    template <class Tuple>
    static typename ByRef<typename TupleElement<5, Tuple>::type>::Type
    GetConstField(const Tuple& tuple) NN_NOEXCEPT
    {
        return tuple.m_F5;
    }
};

template <>
class GetImpl<6> {
public:
    template <class Tuple>
    static typename AddRef<typename TupleElement<6, Tuple>::type>::Type
    GetField(Tuple& tuple) NN_NOEXCEPT
    {
        return tuple.m_F6;  // NOLINT
    }

    template <class Tuple>
    static typename ByRef<typename TupleElement<6, Tuple>::type>::Type
    GetConstField(const Tuple& tuple) NN_NOEXCEPT
    {
        return tuple.m_F6;
    }
};

template <>
class GetImpl<7> {
public:
    template <class Tuple>
    static typename AddRef<typename TupleElement<7, Tuple>::type>::Type
    GetField(Tuple& tuple) NN_NOEXCEPT
    {
        return tuple.m_F7;  // NOLINT
    }

    template <class Tuple>
    static typename ByRef<typename TupleElement<7, Tuple>::type>::Type
    GetConstField(const Tuple& tuple) NN_NOEXCEPT
    {
        return tuple.m_F7;
    }
};

template <>
class GetImpl<8> {
public:
    template <class Tuple>
    static typename AddRef<typename TupleElement<8, Tuple>::type>::Type
    GetField(Tuple& tuple) NN_NOEXCEPT
    {
        return tuple.m_F8;  // NOLINT
    }

    template <class Tuple>
    static typename ByRef<typename TupleElement<8, Tuple>::type>::Type
    GetConstField(const Tuple& tuple) NN_NOEXCEPT
    {
        return tuple.m_F8;
    }
};

template <>
class GetImpl<9> {
public:
    template <class Tuple>
    static typename AddRef<typename TupleElement<9, Tuple>::type>::Type
    GetField(Tuple& tuple) NN_NOEXCEPT
    {
        return tuple.m_F9;  // NOLINT
    }

    template <class Tuple>
    static typename ByRef<typename TupleElement<9, Tuple>::type>::Type
    GetConstField(const Tuple& tuple) NN_NOEXCEPT
    {
        return tuple.m_F9;
    }
};

template <int N, NNT_TESTING_DETAIL_TYPENAMES10(T)>
typename AddRef<
    typename TupleElement<N, NNT_TESTING_DETAIL_TUPLE10(T)>::type>::Type
Get(NNT_TESTING_DETAIL_TUPLE10(T)& tuple) NN_NOEXCEPT
{
    return GetImpl<N>::GetField(tuple);
}

template <int N, NNT_TESTING_DETAIL_TYPENAMES10(T)>
typename ByRef<
    typename TupleElement<N, NNT_TESTING_DETAIL_TUPLE10(T)>::type>::Type
Get(const NNT_TESTING_DETAIL_TUPLE10(T)& tuple) NN_NOEXCEPT
{
    return GetImpl<N>::GetConstField(tuple);
}

template <int I, int J>
struct CompareImpl;

template <>
struct CompareImpl<0, 0> final
{
    template <typename T, typename U>
    static bool Equals(const T& lhs, const U& rhs) NN_NOEXCEPT
    {
        NN_UNUSED(lhs);
        NN_UNUSED(rhs);

        return true;
    }
};

template <int I>
struct CompareImpl<I, I> final
{
    template <typename T, typename U>
    static bool Equals(const T& lhs, const U& rhs) NN_NOEXCEPT
    {
        return CompareImpl<I - 1, I - 1>::Equals(lhs, rhs) &&
            Get<I - 1>(lhs) == Get<I - 1>(rhs);
    }
};

template <NNT_TESTING_DETAIL_TYPENAMES10(T), NNT_TESTING_DETAIL_TYPENAMES10(U)>
inline bool operator==(
    const NNT_TESTING_DETAIL_TUPLE10(T)& lhs,
    const NNT_TESTING_DETAIL_TUPLE10(U)& rhs) NN_NOEXCEPT
{
    return CompareImpl<
        TupleSize<NNT_TESTING_DETAIL_TUPLE10(T)>::value,
        TupleSize<NNT_TESTING_DETAIL_TUPLE10(U)>::value>::Equals(lhs, rhs);
}

template <NNT_TESTING_DETAIL_TYPENAMES10(T), NNT_TESTING_DETAIL_TYPENAMES10(U)>
inline bool operator!=(
    const NNT_TESTING_DETAIL_TUPLE10(T)& lhs,
    const NNT_TESTING_DETAIL_TUPLE10(U)& rhs) NN_NOEXCEPT
{
    return !(lhs == rhs);
}

}}} // namespace nnt::testing::detail
