﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>

namespace nnt { namespace testing { namespace detail {

class CStdlib final
{
public:
    static const int ExitFailure;

    static int32_t Strtol(const char* str, char** endptr, int base) NN_NOEXCEPT;

    static void Exit(int status) NN_NOEXCEPT;

    static char* Getenv(const char* name) NN_NOEXCEPT;

private:
    CStdlib();

    NN_DISALLOW_COPY(CStdlib);
    NN_DISALLOW_MOVE(CStdlib);
};

}}} // namespace nnt::testing::detail
