﻿using System;
using Microsoft.VisualStudio.TestTools.UnitTesting;
using Util;
using System.IO;

namespace UtilTest
{
    [TestClass]
    public class UnitTest1
    {
        static string Root { get; set; }

        [ClassInitialize]
        public static void ClassInit(TestContext context)
        {
            var current = Directory.GetCurrentDirectory();
            Root = Path.GetFullPath(Path.Combine(current, @"..\..\..\..\"));
        }

        [TestMethod]
        public void GenerateRuleTest()
        {
            var rule = RuleGenerator.Generate(Root);

            var correctFilePath = Path.Combine(Root, "BuiltBinaryPath.narl");
            var correctData = File.ReadAllText(correctFilePath);

            // PowerShell でファイルに書き出す際に末尾に改行が足される
            Assert.AreEqual(rule + "\r\n", correctData);
        }

        [TestMethod]
        public void AddFirmwareVersionTest()
        {
            var baseName = @"D:\home\Siglo\sdk\Externals\ReleaseBinaries\NX\Applets\controller_20170930_0755_r71203_4NUP_sdk433_release.4_0_0.nsp";
            var renamed = RenameUtil.AddFirmwareVersion(baseName, "5_0_0");
            Assert.AreEqual(renamed, "controller_20170930_0755_r71203_4NUP_sdk433_release.4_0_0.nsp");


            baseName = @"D:\home\Siglo\sdk\Externals\ReleaseBinaries\NX\Applets\controller_20170930_0755_r71203_4NUP_sdk433_release.nsp";
            renamed = RenameUtil.AddFirmwareVersion(baseName, "5_0_1");
            Assert.AreEqual(renamed, "controller_20170930_0755_r71203_4NUP_sdk433_release.5_0_1.nsp");


            baseName = @"D:\home\Siglo\sdk\Externals\ReleaseBinaries\NX\Processes\Develop\account.5f15389c6ca3.nsp";
            renamed = RenameUtil.AddFirmwareVersion(baseName, "5_1_0");
            Assert.AreEqual(renamed, "account.5f15389c6ca3.5_1_0.nsp");


            baseName = @"D:\home\Siglo\sdk\Externals\ReleaseBinaries\NX\Processes\Develop\account.5f15389c6ca3.4_0_0.nsp";
            renamed = RenameUtil.AddFirmwareVersion(baseName, "5_1_0");
            Assert.AreEqual(renamed, "account.5f15389c6ca3.4_0_0.nsp");
        }

        [TestMethod]
        public void GetOceanFileNameForDeveloperTest()
        {
            var baseName = "controller_20170930_0755_r71203_4NUP_sdk433_release.4_0_0.nsp";
            var renamed = RenameUtil.GetOceanFileNameForDeveloper(baseName);
            Assert.AreEqual(baseName, renamed);
        }
    }
}
