﻿//==============================================================================
//
//  Main entry for ThreadLoggingTest
//  Test comes from Unity Development Team, was reported in SigloNTD-3849
//
//==============================================================================

#include <stdint.h>
#include <nn/nn_Macro.h>
#include <nn/nn_Log.h>
#include <nn/nn_Assert.h>
#include <nn/os.h>

//-----------------------------------------------------------------------------

// Case 1 : Target Manager was crashed.

namespace
{
    const size_t ThreadStackSize = 8192;
    enum { THREAD_MAX = 8 };
    nn::os::ThreadType  g_Threads[THREAD_MAX];
    NN_OS_ALIGNAS_THREAD_STACK char g_ThreadStacks[THREAD_MAX][ThreadStackSize];
}

void ThreadFunction(void *arg)
{
    size_t threadNo = (size_t)arg;
    NN_LOG("Thread %u\n", threadNo);
}

extern "C" void nnMain()
{
    nn::Result result;

    for( int i = 0; i < THREAD_MAX; ++i )
    {
        result = nn::os::CreateThread( &g_Threads[i], ThreadFunction, (void*)i, g_ThreadStacks[i], ThreadStackSize, nn::os::DefaultThreadPriority );
        NN_ASSERT( result.IsSuccess(), "Cannot create g_Thread %d.", i );
    }

    for (int i = 0; i < THREAD_MAX; ++i) // BreakForFreeze
    {
        nn::os::StartThread(&g_Threads[i]);
    }

    for (int i = 0; i < THREAD_MAX; ++i)
    {
        nn::os::WaitThread(&g_Threads[i]);
    }

    for (int i = 0; i < THREAD_MAX; ++i)
    {
        nn::os::DestroyThread(&g_Threads[i]);
    }
}
