﻿//==============================================================================
// Breakpoint Step Test Elf Data
//==============================================================================

/*----------------------------------------------------------------------*
  Project: StepTest
 *----------------------------------------------------------------------*/

double total = 0;

template <typename Type>
void MapName(Type i)
{                                                           //SteppingSimpleTestAddrKey26
    #ifndef __NX__
    i++;
#else
    total += (double)i;                                     //SteppingSimpleTestAddrKey27
#endif

}                                                           //SteppingSimpleTestAddrKey28

int g = 0;

__attribute__((always_inline))
void InlineFunc()
{
    g += 1;                                                 //SteppingSimpleTestAddrKey05
}

void InlineTest()
{                                                           //SteppingSimpleTestAddrKey03
    g += 1;                                                 //SteppingSimpleTestAddrKey04
    InlineFunc();
    g += 1;                                                 //SteppingSimpleTestAddrKey06
    InlineFunc();
    g += 1;                                                 //SteppingSimpleTestAddrKey07

    int i = g;                                              //SteppingSimpleTestAddrKey08
}                                                           //SteppingSimpleTestAddrKey09

void StepTest()
{                                                           //SteppingSimpleTestAddrKey16
    int x = 0;                                              //SteppingSimpleTestAddrKey17

    if( x > 0 )                                             //SteppingSimpleTestAddrKey18
        return;                                             //SteppingSimpleTestAddrKey54

    if( x > 1 )                                             //SteppingSimpleTestAddrKey19
        return;

    if( x > 2 )                                             //SteppingSimpleTestAddrKey20
        return;

    x = -1;                                                 //SteppingSimpleTestAddrKey21
}                                                           //SteppingSimpleTestAddrKey22

void TemplateTest()
{                                                           //SteppingSimpleTestAddrKey24
    MapName(0);                                             //SteppingSimpleTestAddrKey25
    MapName(1);                                             //SteppingSimpleTestAddrKey29
    MapName(2.0f);                                          //SteppingSimpleTestAddrKey30
    MapName(3);                                             //SteppingSimpleTestAddrKey31
    MapName(4.0f);                                          //SteppingSimpleTestAddrKey32
    MapName(5.0f);                                          //SteppingSimpleTestAddrKey33

    int i = 0;                                              //SteppingSimpleTestAddrKey34
}                                                           //SteppingSimpleTestAddrKey35

void Sub2()
{                                                           //SteppingSimpleTestAddrKey14
    StepTest();                                             //SteppingSimpleTestAddrKey15

    TemplateTest();                                         //SteppingSimpleTestAddrKey23

#ifndef __NX__
    int LoopCounter = 1999999;
#else
    int LoopCounter = 999999999;                            //SteppingSimpleTestAddrKey36
#endif

    while( LoopCounter > 0 )
    {
        LoopCounter--;
    }

//    while(true);
//    for(;;);

    return;
}

void Sub1()
{                                                           //SteppingSimpleTestAddrKey11
    int Result = 17;                                        //SteppingSimpleTestAddrKey12

    Sub2();                                                 //SteppingSimpleTestAddrKey13
    return;                                                 //SteppingSimpleTestAddrKey37
}

void RecurseTest( int i )
{                                                           //SteppingSimpleTestAddrKey39
    i--;                                                    //SteppingSimpleTestAddrKey40
    if ( i > 0 )                                            //SteppingSimpleTestAddrKey41
        RecurseTest( i );                                   //SteppingSimpleTestAddrKey42
    else
        i = 0;                                              //SteppingSimpleTestAddrKey43
}                                                           //SteppingSimpleTestAddrKey44

// Test for DejaTool JIRA #355/ NTD JIRA #319
struct NTD319
{
    void Func()
    {                                                       //SteppingSimpleTestAddrKey46
        int x = 0;                                          //SteppingSimpleTestAddrKey47
    }                                                       //SteppingSimpleTestAddrKey48

    void Func2();
};

void NTD319::Func2()
{                                                           //SteppingSimpleTestAddrKey50
    int x = 0;                                              //SteppingSimpleTestAddrKey51
}                                                           //SteppingSimpleTestAddrKey52

template <typename T>
void ComplexFunctionA()
{
    int bpDummy = 0;                                              //ComplexTestAddrKey00
}

template <typename T1, typename T2, typename T3, int TInt=4>
class ComplexTypeA
{
public:
    ComplexTypeA(T1 a, T2& b, T3* c)
        : m_B(b)
    {
        m_A = a;
        m_C = c;

        ComplexFunctionA<decltype(this)>();                      //ComplexTestAddrKey05
    }                                                            //ComplexTestAddrKey06

private:
    T1  m_A;
    T2& m_B;
    T3* m_C;
};

template <typename T>
struct ComplexTypeB
{
public:
    ComplexTypeB() {}
};

void ComplexTemplateTest()
{
    double refA = 4321.1234;
    long ptrA = 20;
    ComplexTypeA<int, double, long> a(4, refA, &ptrA);             //ComplexTestAddrKey07

    ComplexTypeB<ComplexTypeB<const char*>> refB;                  //ComplexTestAddrKey08
    float ptrB;
    ComplexTypeA<float, decltype(refB), float> b(55, refB, &ptrB); //ComplexTestAddrKey09
}                                                                  //ComplexTestAddrKey24

void ComplexLambdaTestFunc()
{
    int bpDummy = 0;                                                //ComplexTestAddrKey02
}

// Currently does not work.
void ComplexLambdaTest()
{
    []()
    {
        int dummy = 50;                                            //ComplexTestAddrKey01

        auto func = [dummy](ComplexTypeA<int, double, float>& a)
        {
            [&dummy]() -> ComplexTypeB<int>
            {
                ComplexLambdaTestFunc();
                return ComplexTypeB<int>();
            }();
        };

        double refA = 100.0;
        float ptrA = 44.2f;
        ComplexTypeA<int, double, float> a(10, refA, &ptrA);

        func(a);
    }();
}

class ITemplatedBase
{
public:
    virtual void Virtual() = 0;
};

template <typename T>
class TemplatedDerived : public ITemplatedBase
{
public:
    virtual void Virtual()
    {
        int bpDummy = 0;                                                  //ComplexTestAddrKey04
    }                                                                     //ComplexTestAddrKey19
};

class Base
{
public:
    virtual ~Base() {}

    virtual void VirtualA()
    {
        int bpDummy = 0;                                                  //ComplexTestAddrKey03
    }                                                                     //ComplexTestAddrKey18

    virtual void VirtualB()
    {
        VirtualC();                                                      //ComplexTestAddrKey14
    }                                                                    //ComplexTestAddrKey25

    virtual void VirtualC() {}
};

class Derived : public Base
{
public:
    ~Derived() {}

    virtual void VirtualA() override
    {
        VirtualB();                                                       //ComplexTestAddrKey12
    }                                                                     //ComplexTestAddrKey17

    virtual void VirtualB() override
    {
        Base::VirtualB();                                                 //ComplexTestAddrKey11
    }                                                                     //ComplexTestAddrKey16

    virtual void VirtualC() override
    {
        Base::VirtualA();                                                 //ComplexTestAddrKey10
    }                                                                     //ComplexTestAddrKey15
};

void ComplexVirtualTest()
{
    Base* derived = new Derived;

    derived->VirtualA();                                                 //ComplexTestAddrKey20

    delete derived;                                                      //ComplexTestAddrKey21

    ITemplatedBase* templatedDerived = new TemplatedDerived<float>();   //ComplexTestAddrKey13

    templatedDerived->Virtual();                                        //ComplexTestAddrKey22
}                                                                       //ComplexTestAddrKey23




NTD319 strNTD;

#ifndef __NX__
int main(int argc, char** argv)
#else
extern "C" void nnMain( void )
#endif
{                                                           //SteppingSimpleTestAddrKey01
    InlineTest();                                           //SteppingSimpleTestAddrKey02

    Sub1();                                                 //SteppingSimpleTestAddrKey10

    RecurseTest( 5 );                                       //SteppingSimpleTestAddrKey38

    strNTD.Func();                                          //SteppingSimpleTestAddrKey45
    strNTD.Func2();                                         //SteppingSimpleTestAddrKey49

    ComplexTemplateTest();                                  //SteppingSimpleTestAddrKey55
    ComplexLambdaTest();                                    //SteppingSimpleTestAddrKey56
    ComplexVirtualTest();                                   //SteppingSimpleTestAddrKey57
    // NOTE: Adding additional code below this comment will break stepping tests.
#ifndef __NX__
    return 0;
#endif
}                                                           //SteppingSimpleTestAddrKey53
