﻿// The purpose of this test is to validate the expression parser can correctly
// display a variety of data types.

#include <cstdint>
#include <stdint.h>
#include "Structures.h"

namespace
{
    int32_t ns_unknownTest = 32;
    namespace NS_TEST
    {
        int32_t NS_TestValue;
        namespace NS_TEST_C
        {
            int32_t NS_TestCounter;
        }
        const int32_t NS_SecondTestValue = 512;
    }
}

typedef void ( *VOIDFUNC )(int i);
typedef const int** PPInt;

//==============================================================================
// Test case for SIGLONTD-3760 (lambda functions)
typedef bool (*TFunctionPtr)(int const);

TFunctionPtr build_fn_ptr()
{
   return [] (int const x)
   {
      return x == 10; // LambdaFunctionsTestBP01
   };
}

// These test cases come from NTD Jira Oasis-882
// http://spdlybra.nintendo.co.jp/jira/browse/OASIS-882

union GlobalUnion
{
    char            UnionA;
    unsigned char   UnionB;
    int             UnionC;
    short           UnionD[2];
} GU;

// Anonymous union test case.
static union
{
    char            GlobalA;
    unsigned char   GlobalB;
    int             GlobalC;
    short           GlobalD[2];
};

struct UnionStruct
{
    union NamedUnion
    {
        // Intentionally using the same names as above.
        char            UnionA;
        unsigned char   UnionB;
        int             UnionC;
        short           UnionD[2];
    } NU;

    // Nested anonymous union.
    union
    {
        // Intentionally using the same names as above.
        char            UnionA;
        unsigned char   UnionB;
        int             UnionC;
        short           UnionD[2];
    };
} GUS;

//==============================================================================

namespace Namespace0
{
    int GLOBAL_INT             = 1;
    const int CONST_GLOBAL_INT = 2;
}

int GLOBAL_INT             = 3;
const int CONST_GLOBAL_INT = 4;
int GLOBAL_MEMBER_CONFLICT = 5;

namespace Namespace1
{
    int GLOBAL_INT                = 6;
    const int CONST_GLOBAL_INT    = 7;
    int GLOBAL_MEMBER_CONFLICT    = 8;

    namespace Namespace2
    {
        int GLOBAL_INT             = 9;
        const int CONST_GLOBAL_INT = 10;
    }

    namespace Namespace3
    {
        int GLOBAL_INT             = 11;
        const int CONST_GLOBAL_INT = 12;
        int GLOBAL_MEMBER_CONFLICT = 13;
        int GLOBAL_STATIC_INT      = 14;

        class NamespaceClass
        {
        public:
            NamespaceClass() :
                GLOBAL_MEMBER_CONFLICT( 0 )
            {
                GLOBAL_MEMBER_CONFLICT = (int)Namespace0::GLOBAL_INT + // GlobalsTestBP01
                                         (int)Namespace0::CONST_GLOBAL_INT +
                                         (int)::GLOBAL_INT +
                                         (int)::CONST_GLOBAL_INT +
                                         (int)Namespace1::GLOBAL_INT +
                                         (int)Namespace1::CONST_GLOBAL_INT +
                                         (int)Namespace1::GLOBAL_MEMBER_CONFLICT +
                                         (int)Namespace2::GLOBAL_INT +
                                         (int)Namespace2::CONST_GLOBAL_INT +
                                         (int)Namespace3::GLOBAL_INT +
                                         (int)Namespace3::CONST_GLOBAL_INT +
                                         (int)Namespace3::GLOBAL_MEMBER_CONFLICT +
                                         (int)Namespace3::GLOBAL_STATIC_INT;

            }
        private:
            int GLOBAL_MEMBER_CONFLICT;
            static int GLOBAL_STATIC_INT;
        };
        int NamespaceClass::GLOBAL_STATIC_INT = 15;
    }
}

enum TestUEnum : unsigned int {
    TestUEnum_A,
    TestUEnum_B,
    TestUEnum_C,
    TestUEnum_D,
};

struct TestUEnumBitfeld {
    TestUEnum TUE : 2;
};

enum TestSEnum : signed int {
    TestSEnum_A = 0,
    TestSEnum_B = 1,
    TestSEnum_C = -1,
    TestSEnum_D = 3,
};

struct TestSEnumBitfeld {
    TestSEnum TSE : 2;
};

enum TestCEnum : unsigned char {
    TestCEnum_A,
    TestCEnum_B,
    TestCEnum_C,
    TestCEnum_D = 128,
};

struct TestCEnumBitfeld {
    TestCEnum TCE;
};

typedef TestUEnum TypeDefTestUEnum;

//==============================================================================

// Wrapping all local stack data within a constructor prevents Rynda from
// optimizing out said data. This enables this test to run on an NX target.
class WrapAllData
{
public:
    WrapAllData( )
    {
        // Various static types.
        static s32 a = 3;
        static f32 b = 7.21f;
        static s64 c = -1;
        static f64 d = 14.4f;
        static u64 e = 92;

        #define ARRAY_X_SIZE    3
        #define ARRAY_XXX_SIZE  3 * 2 * 5

        static s32 ArrayX[3] = { 71, 72, 73 };
        static s32 ArrayXXX[3][2][5] = { 11, 12, 13, 14, 15, 21, 22, 23, 24, 25,
            31, 32, 33, 34, 35, 41, 42, 43, 44, 45,
            51, 52, 53, 54, 55, 61, 62, 63, 64, 65 };

        static test_class ClassA;
        static test_class ClassB;

        ClassA.x     = 5;
        ClassA.y     = 7;
        ClassA.pNext = &ClassB;
        ClassB.x     = 102;
        ClassB.y     = 272;
        ClassB.pNext = &ClassA;
        test_class* pClassA = ClassB.pNext;

        // Pointer to int.
        const void* vpx  = &(ArrayXXX[1][1][1]);
        const int*  px   = (int*)vpx;
        const int** ppx  = &px;
        void**      vppx = (void**)ppx;

        PPInt  ppIntX = ppx;
        void** vppix  = (void**)ppIntX;
        f32*   pfb    = &b;
        int&   ra     = a;

        // Array of struct test.
        test_class TCArray[2];

        TCArray[0].x = 198;
        TCArray[0].y = 199;
        TCArray[0].pNext = &TCArray[1];

        TCArray[1].x = 298;
        TCArray[1].y = 299;
        TCArray[1].pNext = &TCArray[0];

        test_class* TCArrayP[2];
        TCArrayP[0] = &TCArray[0];
        TCArrayP[1] = &TCArray[1];

        int      var      = 42;
        int*     pVar     = &var;
        int**    ppVar    = &pVar;
        int***   pppVar   = &ppVar;
        int****  ppppVar  = &pppVar;
        int***** pppppVar = &ppppVar;

        int list[8]               = { 99, 88, 77, 66, 55, 44, 33, 22 };
        int ( *pList )[8]         = &list;
        int ( **ppList )[8]       = &pList;
        int ( ***pppList )[8]     = &ppList;
        int ( ****ppppList )[8]   = &pppList;
        int ( *****pppppList )[8] = &ppppList;

        int*     pList2[8]     = { &list[0], &list[1], &list[2], &list[3], &list[4], &list[5], &list[6], &list[7] };
        int**    ppList2[8]    = { &pList2[0], &pList2[1], &pList2[2], &pList2[3], &pList2[4], &pList2[5], &pList2[6], &pList2[7] };
        int***   pppList2[8]   = { &ppList2[0], &ppList2[1], &ppList2[2], &ppList2[3], &ppList2[4], &ppList2[5], &ppList2[6], &ppList2[7] };
        int****  ppppList2[8]  = { &pppList2[0], &pppList2[1], &pppList2[2], &pppList2[3], &pppList2[4], &pppList2[5], &pppList2[6], &pppList2[7] };
        int***** pppppList2[8] = { &ppppList2[0], &ppppList2[1], &ppppList2[2], &ppppList2[3], &ppppList2[4], &ppppList2[5], &ppppList2[6], &ppppList2[7] };

        short A = 34; // 0x22 hex.
        short B = 51; // 0x33 hex.
        short C = 68; // 0x44 hex.

        short simple_array[3];
        simple_array[0] = A;
        simple_array[1] = B;
        simple_array[2] = C;

        short ( *pPtrToArray )[3] = &simple_array;

        short* simple_ptr_array[3];
        simple_ptr_array[0] = &A;
        simple_ptr_array[1] = &B;
        simple_ptr_array[2] = &C;

        short* (*pPtrToPtrArray)[3] = &simple_ptr_array;

        short** double_ptr_array[3];
        double_ptr_array[0] = &simple_ptr_array[0];
        double_ptr_array[1] = &simple_ptr_array[1];
        double_ptr_array[2] = &simple_ptr_array[2];

        short** (*pPtrToDoublePtrArray)[3] = &double_ptr_array;

        BitField TestField;
        TestField.A = 3;
        TestField.B = 7;
        TestField.C = 2;
        TestField.D = 0x7FFFFFFFFF;

        BitField* pTestField = &TestField;

        BitfieldX TestFieldOdd;
        TestFieldOdd.A = 4095;  // -1
        TestFieldOdd.B = 4095;  // 4095
        TestFieldOdd.C = -4095; // 1
        TestFieldOdd.D = 199;   // 7
        TestFieldOdd.E = 409;   // 9 '\t'

        test_class* pFoo = 0;

        vector3 vTable[5];
        unsigned long cTable[5];
        for (s32 i = 0; i < 5; i++)
        {
            cTable[i] = 5 + i;
            vTable[i].x = 1 + i * 3;
            vTable[i].y = 50 + i * 7;
            vTable[i].z = 1000 + i * 100;
        }

        vertex_pc Verts[4 * 3];
        for (s32 i = 0; i < 4; i++)
        {
            int i0 = 0;
            int i1 = i + 1;
            int i2 = (i + 1) % 4 + 1;

            Verts[i * 3 + 0].Position = vTable[i0];
            Verts[i * 3 + 0].Color = cTable[i0];
            Verts[i * 3 + 1].Position = vTable[i2];
            Verts[i * 3 + 1].Color = cTable[i2];
            Verts[i * 3 + 2].Position = vTable[i1];
            Verts[i * 3 + 2].Color = cTable[i1];
        }

        color ColorTest ( 48, 49, 50, 51 );

        cell* cell_ptr[10];
        cell  cell_map[10];

        bool bTest = true;

        if (bTest)
        {
            for (int iCell = 0; iCell < 10; iCell++)
            {
                cell_ptr[iCell] = &cell_map[10 - iCell - 1];

                cell_map[iCell].m_i = 0;
                cell_map[iCell].m_j = iCell;

                for (int iBase = 0; iBase < 7; iBase++)
                {
                    cell_map[iCell].m_Base[iBase].x = iCell * 10;
                    cell_map[iCell].m_Base[iBase].y = iBase * 10;
                    cell_map[iCell].m_Base[iBase].z = 2;
                }
            }
        }
        cell** pCellPtr = &cell_ptr[0];

        obj_mgr ObjMgr1;
        obj_mgr ObjMgr2;
        obj_mgr ObjMgr3;

        ObjMgr1.Init ( 3 );
        ObjMgr2.Init ( 7 );
        ObjMgr3.Init ( 9 );

        ObjMgr2.AddToTypes ( 7 );
        ObjMgr2.SetId ( 0xbeefdead );

        ns_unknownTest += ns_unknownTest;
        NS_TEST::NS_TestValue = ns_unknownTest;
        NS_TEST::NS_TEST_C::NS_TestCounter = NS_TEST::NS_SecondTestValue * 2;
        for (int32_t X = 0; X < NS_TEST::NS_TEST_C::NS_TestCounter; X++)
        {
            NS_TEST::NS_TestValue += X;
            if (NS_TEST::NS_TestValue > NS_TEST::NS_SecondTestValue)
                break;
        }

        UnionTest_Anonymous unionTest1;
        unionTest1.control = 170;
        unionTest1.int0 = 5;

        UnionTest_Named unionTest2;
        unionTest2.control = 170;
        unionTest2.internal.float0 = 9.0f;

        ComplexAnonymous anonymousTest;
        anonymousTest.m_ValueNU = 0xff;
        anonymousTest.m_DataU   = 0xcc;
        anonymousTest.m_DataI   = 0xaa;
        anonymousTest.m_DataSA  = 0xee;
        anonymousTest.m_DataSB  = 0xbb;

        anonymousTest.m_StructU  = 0xcc;
        anonymousTest.m_StructI  = 0xaa;
        anonymousTest.m_StructSA = 0xee;
        anonymousTest.m_StructSB = 0xbb;

        LocalTestEnum EnumTest1 = (LocalTestEnum)3;
        LocalTestEnum EnumTest2 = LTE_TEST4;

        cell* pNullCell = 0;
        cell** pCellPtr2 = &pNullCell;
        cell*** pCellPtr3 = &pCellPtr2;

        CellContainer container;
        container.m_pCells = &pNullCell;

        // The following test cases are for indexing into children members of
        // classes. For example, pcp.m_ChildMember[0];.
        ParentContainsMember        pcm;
        ParentContainsPointer       pcp;
        ParentContainsArray         pca;
        ParentContainsPointerArray  pcpa;

        // The members of this anonymous union should NOT be found by the locals,
        // autos, or watch windows.
        union
        {
            int  IntThatShouldNotExist;
            char CharThatShouldNotExist;
            ComplexAnonymous ClassThatShouldNotExist;
        };

        // Adding tests for when variables match the names of functions and typedefs.
        int nnMain  = 0x1;
        int vector3 = 0x1;

        // Identical names but different implementations for nested typedef "DataWrapperImpl".
        DataWrapper1 DW1;
        DataWrapper2 DW2;

        // These test cases come from NTD Jira Oasis-882:
        // http://spdlybra.nintendo.co.jp/jira/browse/OASIS-882
        // Additional data structures added to Structures.h
        // Note that there are many intentionally conflicting names.
        union NamedUnion
        {
            char            UnionA;
            unsigned char   UnionB;
            int             UnionC;
            short           UnionD[2];
        };

        union
        {
            char            UnionA;
            unsigned char   UnionB;
            int             UnionC;
            short           UnionD[2];
        };

        UnionStruct   US;
        NamedUnion    NU;

        GlobalC       = 0x12345678;
        UnionC        = 0x87654321;

        GU.UnionC     = 0x23456789;
        NU.UnionC     = 0x98765432;

        US.NU.UnionC  = 0x01234567;
        US.UnionC     = 0x76543210;

        GUS.NU.UnionC = 0x11223344;
        GUS.UnionC    = 0x22334455;

        struct VoidPointerStruct
        {
            void* pVoidInt;
            void* pVoidClass;
            void* pVoidNull;
        };

        VoidPointerStruct VPS;
        VPS.pVoidInt   = (void*)pVar;
        VPS.pVoidClass = (void*)pClassA;
        VPS.pVoidNull  = nullptr;

        void* pLocalVoidInt   = (void*)pVar;
        void* pLocalVoidClass = (void*)pClassA;
        void* pLocalVoidNull  = nullptr;

        int const * const pConstInt          = new int( 10 );
        int const * const * const ppConstInt = &pConstInt;

        Namespace1::Namespace3::NamespaceClass MyNamespaceClass;

        // Test case as defined by SIGLONTD-4398: http://spdlybra.nintendo.co.jp/jira/browse/SIGLONTD-4398
        API api;
        api.func = Test;

        // Test case as defined by SIGLONTD-3760: http://spdlybra.nintendo.co.jp/jira/browse/SIGLONTD-3760
        TFunctionPtr arr[2];
        arr[0] = build_fn_ptr();
        arr[1] = build_fn_ptr();

        int x = 10;
        for ( TFunctionPtr ptr : arr )
        {
            ptr(x++);
        }

        EmptyStruct LocalEmptyStruct;

        // SigloNTD-9257, various bitfield and custom enums.
        TestUEnumBitfeld TestEnum1;
        TestEnum1.TUE = TestUEnum::TestUEnum_D;
        TestSEnumBitfeld TestEnum2;
        TestEnum2.TSE = TestSEnum::TestSEnum_D;
        TestCEnumBitfeld TestEnum3;
        TestEnum3.TCE = TestCEnum::TestCEnum_D;

        IntObject MyInt( 10 );
        Container MyIntContainer( 20 );
        Container MyObjectContainer( &MyInt );

        TypeDefTestUEnum TestTypeDefEnum = TestUEnum::TestUEnum_C;

        // Siglo-64545: rvalue references.
        float           aFloats[5]  = { 0.0f, 0.25f, 0.5f, 0.75f, 1.0f };
        const auto&&    rvF1        = &aFloats[1];

        short           aShorts[5]  = { 0, 2, 4, 6, 8 };
        const auto&&    rvS1        = &aShorts[1];

        test_class aTC[5]   = { {1, 2, nullptr},{ 3, 4, nullptr },{ 5, 6, nullptr },{ 7, 8, nullptr },{ 9, 10, nullptr } };
        aTC[0].pNext        = &aTC[1];
        aTC[1].pNext        = &aTC[2];
        aTC[2].pNext        = &aTC[3];
        aTC[3].pNext        = &aTC[4];
        aTC[4].pNext        = &aTC[0];

        const auto&& rvTC1  = &aTC[1];

        // Test for various operations on references.
        int     Ints[5] = { 0, 10, 20, 30, 40 };
        int*    pInt = &Ints[2];
        int**   ppInt = &pInt;
        int&    rInt = *pInt;
        int*&   rpInt = pInt;
        int**&  rppInt = ppInt;

        unsigned short      Shorts[5] = { 0, 10, 20, 30, 40 };
        unsigned short*     pShort = &Shorts[2];
        unsigned short**    ppShort = &pShort;
        unsigned short&     rShort = *pShort;
        unsigned short*&    rpShort = pShort;
        unsigned short**&   rppShort = ppShort;

        long addrOfpShort = (long)( pShort );

        unsigned short us16Inf      = 0x7c00;
        unsigned short us16NInf     = 0xFc00;
        unsigned short us16Zero     = 0x0000;
        unsigned short us16NZero    = 0x8000;
        unsigned short us16Nan      = 0x7FFF;
        unsigned short us16NNan     = 0xFFFF;

        __fp16 fp16Inf      = *(__fp16*)(&us16Inf);
        __fp16 fp16NInf     = *(__fp16*)( &us16NInf );
        __fp16 fp16Zero     = *(__fp16*)( &us16Zero );
        __fp16 fp16NZero    = *(__fp16*)( &us16NZero );
        __fp16 fp16Nan      = *(__fp16*)( &us16Nan );
        __fp16 fp16NNan     = *(__fp16*)( &us16NNan );

        __fp16 fp16Val1 = 1.0f;
        __fp16 fp16Val2 = 10.0f;
        __fp16 fp16Val3 = 0.10f;
        __fp16 fp16Val4 = 0.01f;

        int Hold = a + b + c + d + e + ArrayX[0] + ArrayXXX[0][0][0] + (int)TheConstBool + (int)TheConstChar + (int)TheConstDouble + (int)TheConstFloat + (int)TheNegativeConstLongLongInt + (int)ThePositiveConstLongLongInt + (int)TheConstShort + (int)TheConstUInt + (int)TheConstULong + (int)TheConstWCharT + (int)TheConstULongLong + (int)s_AIS3.m_Int + (int)NS1::s_AIS4.m_Int + NS2::s_IS1.m_Int + NS3::NS4::s_IS2[0].m_Int + NS3::NS4::s_IS2[1].m_Int + s_AIU1.m_Int; // BasicVariablesTestBP01 // ErrorsTestBP01 // VariableAddressesTestBP01 // WriteVariablesTestBP01
    }
};

//==============================================================================

#ifndef __NX__
int main( int argc, char** argv )
#else
extern "C" void nnMain ( void )
#endif
{
    WrapAllData wad;
#ifndef __NX__
    return 0;
#endif
}
