﻿/*----------------------------------------------------------------------*
  Project: StepTest
 *----------------------------------------------------------------------*/

#include "assert.h"
#include "stdio.h"
#include <ctime>

extern void SimpleSteps();

time_t CurTime;

int g = 0;
int h = 0;
int i = 0;

void InnerFunc() // Tests calls from inline code
{
    g += 1; // PLACE A BREAKPOINT HERE
}

#ifndef __NX__
__forceinline
#else
inline __attribute__((always_inline))
#endif
int InlineCall()
{
    g += 1;
    InnerFunc();
    return g;
}

#ifndef __NX__
__forceinline
#else
inline __attribute__((always_inline))
#endif
int InlineC2()
{
    InlineCall();
    InlineCall();
    return g;
}

#ifndef __NX__
__forceinline
#else
inline __attribute__((always_inline))
#endif
int InlineC3()
{
    InlineCall();
    InlineCall();
    InlineCall();
    return g;
}

#ifndef __NX__
__forceinline
#else
inline __attribute__((always_inline))
#endif
int InlineC4()
{
    InlineCall();
    InlineCall();
    InlineCall();
    InlineCall();
    return g;
}

#ifndef __NX__
__forceinline
#else
inline __attribute__((always_inline))
#endif
int InlineC5()
{
    InlineCall();
    InlineCall();
    InlineCall();
    InlineCall();
    InlineCall();
    return g;
}

#ifndef __NX__
__forceinline
#else
inline __attribute__((always_inline))
#endif
int InlineC12()
{
    InlineCall();
    InlineC2();
    return g;
}

#ifndef __NX__
__forceinline
#else
inline __attribute__((always_inline))
#endif
int InlineC123()
{
    InlineCall();
    InlineC2();
    InlineC3();
    return g;
}

#ifndef __NX__
__forceinline
#else
inline __attribute__((always_inline))
#endif
int InlineC1234()
{
    InlineCall();
    InlineC2();
    InlineC3();
    InlineC4();
    return g;
}

#ifndef __NX__
__forceinline
#else
inline __attribute__((always_inline))
#endif
int InlineC12345()
{
    InlineCall();
    InlineC2();
    InlineC3();
    InlineC4();
    InlineC5();
    return g;
}

#ifndef __NX__
__forceinline
#else
inline __attribute__((always_inline))
#endif
int InlineC5F()
{
    InlineCall();
    InlineC12();
    InlineC123();
    InlineC1234();
    InlineC12345();
    return g;
}

#ifndef __NX__
__forceinline
#else
inline __attribute__((always_inline))
#endif
int InlineCalls()
{
    InlineCall();
    InlineC2();
    InlineC3();
    InlineC4();
    InlineC5();
    InlineC12();
    InlineC123();
    InlineC1234();
    InlineC12345();
    InlineC5F();
    return g;
}

#ifndef __NX__
__forceinline
#else
inline __attribute__((always_inline))
#endif
int InlineIncr()
{
    g += 1;
    return g;
}

#ifndef __NX__
__forceinline
#else
inline __attribute__((always_inline))
#endif
int InlineI2()
{
    InlineIncr();
    InlineIncr();
    return g;
}

#ifndef __NX__
__forceinline
#else
inline __attribute__((always_inline))
#endif
int InlineI3()
{
    InlineIncr();
    InlineIncr();
    InlineIncr();
    return g;
}

#ifndef __NX__
__forceinline
#else
inline __attribute__((always_inline))
#endif
int InlineI4()
{
    InlineIncr();
    InlineIncr();
    InlineIncr();
    InlineIncr();
    return g;
}

#ifndef __NX__
__forceinline
#else
inline __attribute__((always_inline))
#endif
int InlineI5()
{
    InlineIncr();
    InlineIncr();
    InlineIncr();
    InlineIncr();
    InlineIncr();
    return g;
}

#ifndef __NX__
__forceinline
#else
inline __attribute__((always_inline))
#endif
int InlineI12()
{
    InlineIncr();
    InlineI2();
    return g;
}

#ifndef __NX__
__forceinline
#else
inline __attribute__((always_inline))
#endif
int InlineI123()
{
    InlineIncr();
    InlineI2();
    InlineI3();
    return g;
}

#ifndef __NX__
__forceinline
#else
inline __attribute__((always_inline))
#endif
int InlineI1234()
{
    InlineIncr();
    InlineI2();
    InlineI3();
    InlineI4();
    return g;
}

#ifndef __NX__
__forceinline
#else
inline __attribute__((always_inline))
#endif
int InlineI12345()
{
    InlineIncr();
    InlineI2();
    InlineI3();
    InlineI4();
    InlineI5();
    return g;
}

#ifndef __NX__
__forceinline
#else
inline __attribute__((always_inline))
#endif
int InlineI5F()
{
    InlineIncr();
    InlineI12();
    InlineI123();
    InlineI1234();
    InlineI12345();
    return g;
}

#ifndef __NX__
__forceinline
#else
inline __attribute__((always_inline))
#endif
int InlineIncrs()
{
    InlineIncr();
    InlineI2();
    InlineI3();
    InlineI4();
    InlineI5();
    InlineI12();
    InlineI123();
    InlineI1234();
    InlineI12345();
    InlineI5F();
    return g;
}

#ifndef __NX__
__forceinline
#else
inline __attribute__((always_inline))
#endif
int InlineCI5()
{
    InlineCalls();
    InlineIncrs();
    InlineCalls();
    InlineIncrs();
    InlineCalls();
    InlineIncrs();
    InlineCalls();
    InlineIncrs();
    InlineCalls();
    InlineIncrs();
    return g;
}

#ifndef __NX__
__forceinline
#else
inline __attribute__((always_inline))
#endif
int InlineIC5()
{
    InlineIncrs();
    InlineCalls();
    InlineIncrs();
    InlineCalls();
    InlineIncrs();
    InlineCalls();
    InlineIncrs();
    InlineCalls();
    InlineIncrs();
    InlineCalls();
    return g;
}

// 1-level V-topology
//
//  |-----------|
//      |---|

#ifndef __NX__
__forceinline
#else
inline __attribute__((always_inline))
#endif
int InlineV1( int x )
{
    g += x;
    InlineIncr();
    g += x;
    return g;
}

// 2-level V-topology
//
//  |-------------------|
//      |-----------|
//          |---|

#ifndef __NX__
__forceinline
#else
inline __attribute__((always_inline))
#endif
int InlineV2( int x )
{
    g += x;
    InlineV1(x);
    g += x;
    return g;
}

// 3-level V-topology
//
//  |---------------------------|
//      |-------------------|
//          |-----------|
//              |---|

#ifndef __NX__
__forceinline
#else
inline __attribute__((always_inline))
#endif
int InlineV3( int x )
{
    g += x;
    InlineV2(x);
    g += x;
    return g;
}

// W11-topology
//
//  |-----------------------------------|
//      |-----------|   |-----------|
//          |---|           |---|

#ifndef __NX__
__forceinline
#else
inline __attribute__((always_inline))
#endif
int InlineW11( int x )
{
    g += x;
    InlineV1(x);
    g += x;
    InlineV1(x);
    g += x;
    return g;
}

// W12-topology
//
//  |-------------------------------------------|
//      |-----------|   |-------------------|
//          |---|           |-----------|
//                              |---|

#ifndef __NX__
__forceinline
#else
inline __attribute__((always_inline))
#endif
int InlineW12( int x )
{
    g += x;
    InlineV1(x);
    g += x;
    InlineV2(x);
    g += x;
    return g;
}

// W21-topology
//
//  |-------------------------------------------|
//      |-------------------|   |-----------|
//          |-----------|           |---|
//              |---|

#ifndef __NX__
__forceinline
#else
inline __attribute__((always_inline))
#endif
int InlineW21( int x )
{
    g += x;
    InlineV2(x);
    g += x;
    InlineV1(x);
    g += x;
    return g;
}

// W22-topology
//
//  |---------------------------------------------------|
//      |-------------------|   |-------------------|
//          |-----------|           |-----------|
//              |---|                   |---|

#ifndef __NX__
__forceinline
#else
inline __attribute__((always_inline))
#endif
int InlineW22( int x )
{
    g += x;
    InlineV2(x);
    g += x;
    InlineV2(x);
    g += x;
    return g;
}

// V1-V2-V3-V2-V1-topology
//
//  |------------------------------------------------------------------------------------------------------------------|
//      |-----------|   |-------------------|   |---------------------------|   !------------------|   |-----------|
//          |---|           |-----------|           |-------------------|           |-----------|          |---|
//                              |---|                   |-----------|                   |---|
//                                                          |---|

#ifndef __NX__
__forceinline
#else
inline __attribute__((always_inline))
#endif
int InlineV12321( int x )
{
    g += x;
    InlineV1(x);
    g += x;
    InlineV2(x);
    g += x;
    InlineV3(x);
    g += x;
    InlineV2(x);
    g += x;
    InlineV1(x);
    g += x;
    return g;
}

#ifndef __NX__
__forceinline
#else
inline __attribute__((always_inline))
#endif
int InlineFuncs()
{
    InlineIC5();
    InlineCI5();
    InlineW11(1);
    InlineW12(1);
    InlineW21(1);
    InlineW22(1);
    InlineV12321(1);
    InlineW22(1);
    InlineW21(1);
    InlineW12(1);
    InlineW11(1);
    InlineCI5();
    InlineIC5();

    return( g );
}

int InlineTest()
{
    int x = 0;              // InlineTest.BP
    x += InlineFuncs();
    x += InlineFuncs();
    x += InlineFuncs();
    x += InlineFuncs();
    x += InlineFuncs();
    x += InlineFuncs();
    x += InlineFuncs();
    x += InlineFuncs();
    x += InlineFuncs();
    x += InlineFuncs();
    x += InlineFuncs();
    x += InlineFuncs();
    x += InlineFuncs();
    x += InlineFuncs();
    x += InlineFuncs();
    x += InlineFuncs();
    x += InlineFuncs();
    x += InlineFuncs();
    x += InlineFuncs();
    x += InlineFuncs();
    x += InlineFuncs();
    x += InlineFuncs();
    x += InlineFuncs();
    x += InlineFuncs();
    x += InlineFuncs();
    x += InlineFuncs();
    x += InlineFuncs();
    x += InlineFuncs();
    x += InlineFuncs();
    x += InlineFuncs();
    return( x );
}

#ifndef __NX__
__forceinline
#else
inline __attribute__((always_inline))
#endif
int UnusedInline( int x )
{
    return( x + x );
}

void RecurseTest( int i ) // Tests StepOut
{
    i--;
    if ( i > 0 )
    {
        RecurseTest( i );
    }
    else
    {
        i = 0;
    }
}

time_t GetCurTime()
{
    time( &CurTime );

    return( CurTime );
}

#ifndef __NX__
int main(int argc, char** argv)
#else
extern "C" void nnMain( void )
#endif
{
    printf( "StepPerfTest starting...\n" );

    SimpleSteps();

    time_t  tStart  = GetCurTime();
    time_t  tCur    = tStart;
    time_t  tPrev   = tStart;
    time_t  tDelta  = tCur - tPrev;

    while(true)
    {
        tCur    = GetCurTime();                         // TopOfMainLoop
        tDelta  = tCur - tPrev;

        // Provide print at regular intervals to test functions after attach
        if( tDelta >= 10 )
        {
            printf( "Elapsed time: %lld seconds\n", tCur - tStart );
            tPrev = tCur;
        }

        InlineTest();
    }

    printf( "StepPerfTest completed\n" );

#ifndef __NX__
    return 0;
#endif
}
