﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Log.h>
#include <nn/os/os_SdkThreadApi.h>
#include <nn/time/time_Api.h>
#include <mutex>

struct NroTlsStruct3
{
    int             mInt        = 0x3;
    long long       mLongLong   = 0x30;
    NroTlsStruct3*  mpStruct    = nullptr;
    char            mChar       = '3';
};

extern std::mutex gCoutMutex;

thread_local int    gNroTlsInt3     = 0x33333333;
thread_local float  gNroTlsFloat3   = 3.0f;

void NroPrint3()
{
    thread_local int            tlsInt      = 0x30303030;
    thread_local float          tlsFloat    = 30.0f;
    thread_local NroTlsStruct3* tlsStruct   = nullptr;
    tlsStruct = new NroTlsStruct3();

    gCoutMutex.lock();
    NN_LOG( "NroPrint3()\n" );
    NN_LOG( "NroPrint3: gNroTlsInt3: (0x%p): %x, gNroTlsFloat3: (0x%p): %f\n", &gNroTlsInt3, gNroTlsInt3, &gNroTlsFloat3, gNroTlsFloat3 );
    NN_LOG( "NroPrint3: tlsInt:      (0x%p): %x, tlsFloat:      (0x%p): %f\n", &tlsInt, tlsInt, &tlsFloat, tlsFloat );
    NN_LOG( "NroPrint3: tlsStruct:   (0x%p): {%x, %llx, %p, %c}\n", &tlsStruct, tlsStruct->mInt, tlsStruct->mLongLong, tlsStruct->mpStruct, tlsStruct->mChar );
    NN_LOG( "\n" );
    gCoutMutex.unlock();

    nn::os::SleepThread( nn::TimeSpan::FromSeconds( 1 ) ); // Set breakpoint here.

    delete tlsStruct;
}
