﻿//==============================================================================
// Test06: Max DLL load and unload
//==============================================================================

#include "stdafx.h"
#include <string>
#include <nn/init.h>
#include <nn/os.h>
#include <nn/fs.h>
#include <nn/nn_Assert.h>
#include <nn/mem/mem_StandardAllocator.h>
#include "..\DLLCode\DLLCode.h"
#include "..\Common\Common.h"

//==============================================================================

const int MAX_SYSTEM_NRO = 64;
dll_code* g_DLLs[MAX_SYSTEM_NRO]; // Max system NRO

extern "C" void nnMain()
{
    //===========================================
    // Init system.
    Common_Init();

    char Buffer[64];
    const char* BaseName = "Module";

    int i = MAX_SYSTEM_NRO;
    while( i-- )
    {
        memset( Buffer, '\0', 64 );
        sprintf( Buffer, "%s%d", BaseName, i );
        g_DLLs[i] = new dll_code( Buffer );
        if( g_DLLs[i]->Load() == true )
        {
            strcat( Buffer, "_ReturnOne" );
            int One = Common_TestDLLReturnIntCall( g_DLLs[i], Buffer );
            NN_ASSERT( One == 1 );
        }
    }
    i = MAX_SYSTEM_NRO;  //MaxModules
    while( i-- )
    {
        g_DLLs[i]->Unload();
        delete g_DLLs[i];
    }

    Common_Close(); //MinModules
}
