// Assembly code for AsmSIMD testcase

// Generic prolog and epilog macros using C++ syntax

#define GLOBAL_FUNC(name)   .section .text,"ax"; .align 4; .global name; .type name,STT_FUNC; name:; .cfi_startproc
#define LOCAL_FUNC(name)    .section .text,"ax"; .align 4; .type name,STT_FUNC; name:; .cfi_startproc
#define END_FUNC(name)      .size name, [.-name]; .cfi_endproc

#define GLOBAL_DATA(name)   .section .data,"ax"; .align 4; .global name; .type name,STT_OBJECT; name:
#define LOCAL_DATA(name)    .section .data,"ax"; .align 4; .type name,STT_OBJECT; name:
#define END_DATA(name)      .size name, [.-name]

#define MIN_FUNC(name)      .section .text,"ax"; .align 4; .global name; .type name,STT_FUNC; name:

// Precise global function prolog and epilog macros using assembler syntax

.macro function_prolog name:req
    .section    .text,"ax"
    .align      4
    .global     \name
    .type       \name,STT_FUNC
\name:
    .cfi_startproc
    stp         x29, x30, [sp, #-16]! 
    .cfi_def_cfa_offset 16
    mov         x29, sp
    .cfi_def_cfa_register 29
    .cfi_offset 30, -8
    .cfi_offset 29, -16
.endm

.macro function_epilog name:req
    mov         sp, x29
    ldp         x29, x30, [sp], #16
    .cfi_def_cfa 31, 0
    .cfi_same_value 30
    .cfi_same_value 29
    ret
    .size \name, [.-\name]
    .cfi_endproc
.endm

// preserve_caller_vectors(): Push first 64-bits of v8-v15 on stack (sp)
.macro preserve_caller_vectors
    stp      d8, d9, [sp,#-16]!
    stp     d10,d11, [sp,#-16]!
    stp     d12,d13, [sp,#-16]!
    stp     d14,d15, [sp,#-16]!
.endm

// restore_caller_vectors(): Restore first 64-bits from v8v-15 on stack (sp)
.macro restore_caller_vectors
    ldp     d14, d15, [sp], #16
    ldp     d12, d13, [sp], #16
    ldp     d10, d11, [sp], #16
    ldp      d8,  d9, [sp], #16
.endm

// Minimal function definition

    .section    .text,"ax"
    .align      4
    .global     _xyzzy
    .type       _xyzzy, %function
_xyzzy:
    ret
    .size       _xyzzy, [. - _xyzzy]

// Both C and C++ call this function with registers,
// so only the name needs to be different.

.section .text,"ax"; .align 4; .global simd_test_c; .type simd_test_c,STT_FUNC;
simd_test_c: // Wrapper for C

function_prolog _Z9simd_testPvS_S_S_    // Function with mangled name for C++

    ldr     q0, [x0]
    ldr     q1, [x1]
    ldr     q2, [x2]
    ldr     q3, [x3]

    bl      _xyzzy

    fadd    v1.4s, v0.4s, v0.4s
    faddp   v2.4s, v0.4s, v0.4s
    fmul    v3.4s, v0.4s, v0.4s

    mov     v2.s[3], v1.s[2]

    str     q0, [x0]
    str     q1, [x1]
    str     q2, [x2]
    str     q3, [x3]

function_epilog _Z9simd_testPvS_S_S_

    .size name, [.-name]    // Wrapper for C
