:: ---------------------------------------------------------------------------
:: Copyright (C)2014 Nintendo Co., Ltd.  All rights reserved.
::
:: These coded instructions, statements, and computer programs contain
:: proprietary information of Nintendo of America Inc. and/or Nintendo
:: Company Ltd., and are protected by Federal copyright law.  They may
:: not be disclosed to third parties or copied or duplicated in any form,
:: in whole or in part, without the prior written consent of Nintendo.
:: ---------------------------------------------------------------------------

@echo off
setlocal

::-------------------------------------------------------------------------------
:: バッチファイルに与えられた引数をインストールすべきテンプレートディレクトリへの
:: パスとみなし、インストールルーチンを呼び出します。
::-------------------------------------------------------------------------------

:: テンプレートのインストールを実行
if not "%*" == "" (
    call :install "%*"
) else (
    rem  インストールするテンプレートディレクトリが指定されていません。終了します。
    echo Not specified template directories to copy. Exiting.
)

:: 終了
exit /b


::-------------------------------------------------------------------------------
:install
::-------------------------------------------------------------------------------

:: MyDocuments のパスを取得
set shellFoldersReg=HKCU\Software\Microsoft\Windows\CurrentVersion\Explorer\Shell Folders
for /f "usebackq tokens=*" %%i in (`reg query "%shellFoldersReg%" /v Personal`) do set myDocumentsRegValue=%%i
set myDocumentsPath=%myDocumentsRegValue:Personal    REG_SZ    =%

:: Visual Studio 2012 のプロジェクトテンプレート格納先をレジストリから取得
set vs2012Reg=HKCU\Software\Microsoft\VisualStudio\11.0
for /f "usebackq tokens=*" %%i in (`reg query "%vs2012Reg%" /v UserProjectTemplatesLocation`) do set vs2012RegValue=%%i

:: レジストリの値が見つかれば、インストールを行う
if not "%vs2012RegValue%" == "" (
    call :install_for_vs "%~1" "%vs2012RegValue:UserProjectTemplatesLocation    REG_EXPAND_SZ    =%"
) else (
    rem  Visual Studio 2012 が見つかりませんでした。テンプレートのインストールをスキップします。
    echo Could not detect Visual Studio 2012 installation. Skipping template copying.
)

:: Visual Studio 2013 のプロジェクトテンプレート格納先をレジストリから取得
set vs2013Reg=HKCU\Software\Microsoft\VisualStudio\12.0
for /f "usebackq tokens=*" %%i in (`reg query "%vs2013Reg%" /v UserProjectTemplatesLocation`) do set vs2013RegValue=%%i

:: レジストリの値が見つかれば、インストールを行う
if not "%vs2013RegValue%" == "" (
    call :install_for_vs "%~1" "%vs2013RegValue:UserProjectTemplatesLocation    REG_EXPAND_SZ    =%"
) else (
    rem  Visual Studio 2013 が見つかりませんでした。テンプレートのインストールをスキップします。
    echo Could not detect Visual Studio 2013 installation. Skipping template copying.
)

:: Visual Studio 2015 のプロジェクトテンプレート格納先をレジストリから取得
set vs2015Reg=HKCU\Software\Microsoft\VisualStudio\14.0
for /f "usebackq tokens=*" %%i in (`reg query "%vs2015Reg%" /v UserProjectTemplatesLocation`) do set vs2015RegValue=%%i

:: レジストリの値が見つかれば、インストールを行う
if not "%vs2015RegValue%" == "" (
    call :install_for_vs "%~1" "%vs2015RegValue:UserProjectTemplatesLocation    REG_EXPAND_SZ    =%"
) else (
    rem  Visual Studio 2015 が見つかりませんでした。テンプレートのインストールをスキップします。
    echo Could not detect Visual Studio 2015 installation. Skipping template copying.
)

:: Visual Studio 2017 のプロジェクトテンプレート格納先を MyDocuments のパスから取得
set vs2017UserProjectTemplatesLocation=%myDocumentsPath%\Visual Studio 2017\Templates\ProjectTemplates

:: ディレクトリが存在すれば、インストールを行う
if not "%vs2017UserProjectTemplatesLocation%" == "" (
    call :install_for_vs "%~1" "%vs2017UserProjectTemplatesLocation%"
) else (
    rem  Visual Studio 2017 が見つかりませんでした。テンプレートのインストールをスキップします。
    echo Could not detect Visual Studio 2017 installation. Skipping template copying.
)

:: 終了
exit /b


::-------------------------------------------------------------------------------
:install_for_vs
::-------------------------------------------------------------------------------

:: インストール先ディレクトリを定義
set installDirName=NintendoSDK
set installDir=%~2\%installDirName%
rem  "%installDir%" にプロジェクトテンプレートをインストールします。
echo Copying project templates to "%installDir%"

:: テンプレートが既にインストールされていれば、一旦削除
if exist "%installDir%" (
    rem  既存のテンプレートディレクトリを削除します。
    echo Removing the existing template directory.
    rmdir "%installDir%" /s /q
    if not %ERRORLEVEL% == 0 (
        rem  "%installDir%" の削除に失敗しました。
        echo Failed to remove "%installDir%"
        exit /b
    )
)

:: テンプレートをインストール
for %%D in (%~1) do (
    rem  %%~nD をインストールします。
    echo Copying %%~nD
    xcopy "%%D" "%installDir%\%%~nD\" /q /e
    if not %ERRORLEVEL% == 0 (
        rem  %%D のインストールに失敗しました。
        echo Failed to copy %%D
    )
)

:: 終了
exit /b
