﻿/// <header>
///   <version>0.0.0</version>
/// </header>

/// <tag name="Combine">
///   <func id="CombF4"/>
/// </tag>
/// <func id="CombF4" name="CombF4">
///   <in name="f1" type="float"/>
///   <in name="f2" type="float"/>
///   <in name="f3" type="float"/>
///   <in name="f4" type="float"/>
///   <return type="vec4"/>
///   <description>float 4入力から vec4 を出力</description>
/// </func>
/// <block guid="{48922679-4DFC-4E94-85E4-150A92743A9F}" displayname="CombineF4">
///   <func id="CombF4"/>
///   <out displayname="vec4" type="vec4" target="return"/>
///   <in displayname="x" type="float" target="f1"/>
///   <in displayname="y" type="float" target="f2"/>
///   <in displayname="z" type="float" target="f3"/>
///   <in displayname="w" type="float" target="f4"/>
/// </block>
/// <code funcid="CombF4">
vec4 CombF4( float f1, float f2, float f3, float f4)
{
  return vec4( f1, f2, f3, f4 );
}
/// </code>

/// <tag name="Combine">
///   <func id="CombF3"/>
/// </tag>
/// <func id="CombF3" name="CombF3">
///   <in name="f1" type="float"/>
///   <in name="f2" type="float"/>
///   <in name="f3" type="float"/>
///   <return type="vec3"/>
///   <description>float 3入力から vec3 を出力</description>
/// </func>
/// <block guid="{48922679-4DFC-4E94-85E5-150A93743A9F}" displayname="CombineF3">
///   <func id="CombF3"/>
///   <out displayname="vec3" type="vec3" target="return"/>
///   <in displayname="x" type="float" target="f1"/>
///   <in displayname="y" type="float" target="f2"/>
///   <in displayname="z" type="float" target="f3"/>
/// </block>
/// <code funcid="CombF3">
vec3 CombF3( float f1, float f2, float f3 )
{
  return vec3( f1, f2, f3 );
}
/// </code>

/// <tag name="Combine">
///   <func id="CombF2"/>
/// </tag>
/// <func id="CombF2" name="CombF2">
///   <in name="f1" type="float"/>
///   <in name="f2" type="float"/>
///   <return type="vec2"/>
///   <description>float 2入力から vec2 を出力</description>
/// </func>
/// <block guid="{48932679-4DFC-4E94-85E5-150A93743A9F}" displayname="CombineF2">
///   <func id="CombF2"/>
///   <out displayname="vec2" type="vec2" target="return"/>
///   <in displayname="x" type="float" target="f1"/>
///   <in displayname="y" type="float" target="f2"/>
/// </block>
/// <code funcid="CombF2">
vec2 CombF2( float f1, float f2 )
{
  return vec2( f1, f2 );
}
/// </code>

/// <tag name="Combine">
///   <func id="CombV3F"/>
/// </tag>
/// <func id="CombV3F" name="CombV3F">
///   <in name="v" type="vec3"/>
///   <in name="f" type="float"/>
///   <return type="vec4"/>
///   <description>vec3 と float から vec4 を出力</description>
/// </func>
/// <block guid="{48922679-3DFC-4E94-85E4-150A92743A9F}" displayname="CombineV3F">
///   <func id="CombV3F"/>
///   <out displayname="vec4" type="vec4" target="return"/>
///   <in displayname="xyz" type="vec3" target="v"/>
///   <in displayname="w" type="float" target="f"/>
/// </block>
/// <code funcid="CombV3F">
vec4 CombV3F( vec3 v, float f )
{
  return vec4( v, f );
}
/// </code>

/// <tag name="Combine">
///   <func id="ScaleV2F"/>
/// </tag>
/// <func id="ScaleV2F" name="ScaleV2F">
///   <in name="v" type="vec2"/>
///   <in name="f" type="float"/>
///   <return type="vec2"/>
///   <description>vec2 を float でスケールします。</description>
/// </func>
/// <block guid="{48922679-3DFC-4E94-95E3-150A92743A9F}" displayname="ScaleV2F">
///   <func id="ScaleV2F"/>
///   <out displayname="vec2" type="vec2" target="return"/>
///   <in displayname="xy" type="vec2" target="v"/>
///   <in displayname="f" type="float" target="f"/>
/// </block>
/// <code funcid="ScaleV2F">
vec2 ScaleV2F( vec2 v, float f )
{
  return v * f;
}
/// </code>

/// <tag name="Combine">
///   <func id="ScaleV3F"/>
/// </tag>
/// <func id="ScaleV3F" name="ScaleV3F">
///   <in name="v" type="vec3"/>
///   <in name="f" type="float"/>
///   <return type="vec3"/>
///   <description>vec3 を float でスケールします。</description>
/// </func>
/// <block guid="{48922679-3DFC-4E94-85E3-150A92743A9F}" displayname="ScaleV3F">
///   <func id="ScaleV3F"/>
///   <out displayname="vec3" type="vec3" target="return"/>
///   <in displayname="xyz" type="vec3" target="v"/>
///   <in displayname="f" type="float" target="f"/>
/// </block>
/// <code funcid="ScaleV3F">
vec3 ScaleV3F( vec3 v, float f )
{
  return v * f;
}
/// </code>

/// <tag name="Combine">
///   <func id="Dfdx"/>
/// </tag>
/// <func id="Dfdx" name="Dfdx">
///   <in name="uv" type="vec2"/>
///   <return type="vec2"/>
///   <description>dFdx します。</description>
/// </func>
/// <block guid="{48922679-3DFC-4E94-85E1-150A92743A9F}" displayname="Dfdx">
///   <func id="Dfdx"/>
///   <out displayname="vec2" type="vec2" target="return"/>
///   <in displayname="uv" type="vec2" target="uv"/>
/// </block>
/// <code funcid="Dfdx">
vec2 Dfdx( vec2 uv)
{
  return dFdx(uv);
}
/// </code>

/// <tag name="Combine">
///   <func id="Dfdy"/>
/// </tag>
/// <func id="Dfdy" name="Dfdy">
///   <in name="uv" type="vec2"/>
///   <return type="vec2"/>
///   <description>dFdy します。</description>
/// </func>
/// <block guid="{48922679-3DFC-4E94-85E0-150A92743A9F}" displayname="Dfdy">
///   <func id="Dfdy"/>
///   <out displayname="vec2" type="vec2" target="return"/>
///   <in displayname="uv" type="vec2" target="uv"/>
/// </block>
/// <code funcid="Dfdy">
vec2 Dfdy( vec2 uv)
{
  return dFdy(uv);
}
/// </code>

/// <tag name="Combine">
///   <func id="CalcCurrOffset"/>
/// </tag>
/// <func id="CalcCurrOffset" name="CalcCurrOffset">
///   <in name="nNumSamples" type="int"/>
///   <in name="fStepSize" type="float"/>
///   <in name="texCoord" type="vec2"/>
///   <in name="dx" type="vec2"/>
///   <in name="dy" type="vec2"/>
///   <in name="vMaxOffset" type="vec2"/>
///   <return type="vec2"/>
///   <description>CalcCurrOffset します。</description>
/// </func>
/// <block guid="{48922679-3DFC-4E94-85E2-150A92743A9F}" displayname="CalcCurrOffset">
///   <func id="CalcCurrOffset"/>
///   <out displayname="vCurrOffset" type="vec2" target="return"/>
///   <in displayname="nNumSamples" type="int" target="nNumSamples"/>
///   <in displayname="fStepSize" type="float" target="fStepSize"/>
///   <in displayname="texCoord" type="vec2" target="texCoord"/>
///   <in displayname="dx" type="vec2" target="dx"/>
///   <in displayname="dy" type="vec2" target="dy"/>
///   <in displayname="vMaxOffset" type="vec2" target="vMaxOffset"/>
/// </block>
/// <code funcid="CalcCurrOffset">
vec2 CalcCurrOffset( int nNumSamples, float fStepSize, vec2 texCoord, vec2 dx, vec2 dy, vec2 vMaxOffset )
{
  float fCurrRayHeight = 1.0;
  vec2 vCurrOffset = vec2( 0, 0 );
  vec2 vLastOffset = vec2( 0, 0 );
  float fLastSampledHeight = 1;
  float fCurrSampledHeight = 1;
  int nCurrSample = 0;

  while ( nCurrSample < nNumSamples )
  {
    fCurrSampledHeight = textureGrad(nwAlbedoTexture1, texCoord + vCurrOffset, dx, dy ).a;
    if ( fCurrSampledHeight > fCurrRayHeight )
    {
      float delta1 = fCurrSampledHeight - fCurrRayHeight;
      float delta2 = ( fCurrRayHeight + fStepSize ) - fLastSampledHeight;
      float ratio = delta1/(delta1+delta2);
      vCurrOffset = (ratio) * vLastOffset + (1.0-ratio) * vCurrOffset;
      nCurrSample = nNumSamples + 1;
    }
    else
    {
      nCurrSample++;
      fCurrRayHeight -= fStepSize;
      vLastOffset = vCurrOffset;
      vCurrOffset += fStepSize * vMaxOffset;
      fLastSampledHeight = fCurrSampledHeight;
    }
  }

  return vCurrOffset;
}
/// </code>

/// <tag name="Combine">
///   <func id="CombV3F_1ch"/>
/// </tag>
/// <func id="CombV3F_1ch" name="CombV3F_1ch">
///   <in name="f1" type="float"/>
///   <in name="f4" type="float"/>
///   <return type="vec4"/>
///   <description>float 2入力から vec4（xxxw） を出力</description>
/// </func>
/// <block guid="{EEE334BF-F72D-478A-A0C2-EB22AA02E766}" displayname="CombineV3F_1ch">
///   <func id="CombV3F_1ch"/>
///   <out displayname="vec4" type="vec4" target="return"/>
///   <in displayname="x" type="float" target="f1"/>
///   <in displayname="w" type="float" target="f4"/>
/// </block>
/// <code funcid="CombV3F_1ch">
vec4 CombV3F_1ch( float f1, float f4 )
{
  return vec4( f1, f1, f1, f4 );
}
/// </code>

