﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "ServerManager.h"

#include <type_traits>
#include <nn/sf/sf_HipcServer.h>

#include "ServiceHolder.h"

namespace nnt{ namespace vi{
    ServerManager g_ServerManager;

    namespace {
        const char ServiceName[] = "vi:T";

        static const int SessionCountMax = 4;
        static const int PortCount = 1;

        struct ServerManagerOption
        {
            static const int SubDomainCountMax = 32;
            static const int ObjectInSubDomainCountMax = 128;
        };

        class ServerManagerInstance
            : public nn::sf::HipcSimpleAllInOneServerManager<SessionCountMax, PortCount, ServerManagerOption>
        {
        };

        std::aligned_storage<
            sizeof(ServerManagerInstance),
            NN_ALIGNOF(ServerManagerInstance)
            >::type g_ServerManagerInstanceStorage;
        ServerManagerInstance* g_pServerManagerInstance = nullptr;
    }


    void ServerManager::Initialize() NN_NOEXCEPT
    {
        NN_SDK_REQUIRES(!g_pServerManagerInstance);
        g_pServerManagerInstance = new (&g_ServerManagerInstanceStorage) ServerManagerInstance;

        NN_ABORT_UNLESS_RESULT_SUCCESS(
            g_pServerManagerInstance->RegisterObjectForPort(
                ServiceHolder::Get(),
                static_cast<int32_t>(SessionCountMax),
                ServiceName
            )
        );

        g_pServerManagerInstance->Start();
    }

    void ServerManager::Finalize() NN_NOEXCEPT
    {
        NN_SDK_REQUIRES_NOT_NULL(g_pServerManagerInstance);

        g_pServerManagerInstance->~ServerManagerInstance();
        g_pServerManagerInstance = nullptr;
    }

    void ServerManager::Run() NN_NOEXCEPT
    {
        NN_SDK_REQUIRES_NOT_NULL(g_pServerManagerInstance);

        g_pServerManagerInstance->LoopAuto();
    }

}}
