﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <crtdbg.h>
#include <nnt.h>
#include "testVi_MemoryCheckpoint.h"

class MemoryCheckpointImpl
{
    public:
        MemoryCheckpointImpl() NN_NOEXCEPT
        {
            _CrtMemCheckpoint(&m_Checkpoint);
        }

        ~MemoryCheckpointImpl() NN_NOEXCEPT
        {
            _CrtMemState current;
            NN_UNUSED(current);
            _CrtMemCheckpoint(&current);

            _CrtMemState diff;
            NN_UNUSED(diff);
            EXPECT_FALSE(_CrtMemDifference(&diff, &m_Checkpoint, &current));
        }
    private:
        _CrtMemState m_Checkpoint;
};

MemoryCheckpoint::MemoryCheckpoint() NN_NOEXCEPT
    : m_Impl(new (std::nothrow) MemoryCheckpointImpl)
{
}

MemoryCheckpoint::~MemoryCheckpoint() NN_NOEXCEPT
{
}
